"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveTimelineButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline = require("../../../../../common/api/timeline");
var _user_privileges = require("../../../../common/components/user_privileges");
var _save_timeline_modal = require("./save_timeline_modal");
var timelineTranslations = _interopRequireWildcard(require("./translations"));
var _selectors = require("../header/selectors");
var _step_config = require("../../timeline/tour/step_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SaveTimelineButton = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const [showEditTimelineOverlay, setShowEditTimelineOverlay] = (0, _react.useState)(false);
  const closeSaveTimeline = (0, _react.useCallback)(() => {
    setShowEditTimelineOverlay(false);
  }, []);
  const openEditTimeline = (0, _react.useCallback)(() => {
    setShowEditTimelineOverlay(true);
  }, []);

  // Case: 1
  // check if user has crud privileges so that user can be allowed to edit the timeline
  // Case: 2
  // TODO: User may have Crud privileges but they may not have access to timeline index.
  // Do we need to check that?
  const {
    kibanaSecuritySolutionsPrivileges: {
      crud: canEditTimelinePrivilege
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const getTimelineStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineStatusByIdSelector)(), []);
  const {
    status: timelineStatus,
    isSaving
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineStatus(state, timelineId));
  const canEditTimeline = canEditTimelinePrivilege && timelineStatus !== _timeline.TimelineStatus.immutable;
  const isUnsaved = timelineStatus === _timeline.TimelineStatus.draft;
  const tooltipContent = canEditTimeline ? null : timelineTranslations.CALL_OUT_UNAUTHORIZED_MSG;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    position: "bottom",
    "data-test-subj": "save-timeline-btn-tooltip"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    id: _step_config.TIMELINE_TOUR_CONFIG_ANCHORS.SAVE_TIMELINE,
    fill: true,
    color: "primary",
    onClick: openEditTimeline,
    size: "s",
    iconType: "save",
    isLoading: isSaving,
    disabled: !canEditTimeline,
    "data-test-subj": "save-timeline-action-btn"
  }, timelineTranslations.SAVE), showEditTimelineOverlay && canEditTimeline ? /*#__PURE__*/_react.default.createElement(_save_timeline_modal.SaveTimelineModal, {
    closeSaveTimeline: closeSaveTimeline,
    initialFocusOn: isUnsaved ? 'title' : 'save',
    timelineId: timelineId,
    showWarning: false
  }) : null));
});
exports.SaveTimelineButton = SaveTimelineButton;
SaveTimelineButton.displayName = 'SaveTimelineButton';