"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userZoomed = exports.userStoppedPanning = exports.userStartedPanning = exports.userSetZoomLevel = exports.userSetRasterSize = exports.userSetPositionOfCamera = exports.userNudgedCamera = exports.userMovedPointer = exports.userClickedZoomOut = exports.userClickedZoomIn = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/security_solution/analyzer');
const userSetZoomLevel = actionCreator('USER_SET_ZOOM_LEVEL');
exports.userSetZoomLevel = userSetZoomLevel;
const userClickedZoomOut = actionCreator('USER_CLICKED_ZOOM_OUT');
exports.userClickedZoomOut = userClickedZoomOut;
const userClickedZoomIn = actionCreator('USER_CLICKED_ZOOM_IN');
exports.userClickedZoomIn = userClickedZoomIn;
const userZoomed = actionCreator('USER_ZOOMED');
exports.userZoomed = userZoomed;
const userSetRasterSize = actionCreator('USER_SET_RASTER_SIZE');

/**
 * When the user warps the camera to an exact point instantly.
 */
exports.userSetRasterSize = userSetRasterSize;
const userSetPositionOfCamera = actionCreator('USER_SET_CAMERA_POSITION');
exports.userSetPositionOfCamera = userSetPositionOfCamera;
const userStartedPanning = actionCreator('USER_STARTED_PANNING');
exports.userStartedPanning = userStartedPanning;
const userStoppedPanning = actionCreator('USER_STOPPED_PANNING');
exports.userStoppedPanning = userStoppedPanning;
const userNudgedCamera = actionCreator('USER_NUDGE_CAMERA');
exports.userNudgedCamera = userNudgedCamera;
const userMovedPointer = actionCreator('USER_MOVED_POINTER');
exports.userMovedPointer = userMovedPointer;