"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _risk_score = require("../../../../explore/containers/risk_score");
var _links = require("../../../../common/components/links");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _redirect_to_hosts = require("../../../../common/components/link_to/redirect_to_hosts");
var _types = require("../../../../app/types");
var _model = require("../../../../explore/hosts/store/model");
var _store = require("../../../../explore/hosts/store");
var _store2 = require("../../../../explore/users/store");
var _redirect_to_users = require("../../../../common/components/link_to/redirect_to_users");
var _model2 = require("../../../../explore/users/store/model");
var _use_anomalies_search = require("../../../../common/components/ml/anomaly/use_anomalies_search");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _manage_query = require("../../../../common/components/page/manage_query");
var _anomalies = require("../anomalies");
var _helpers = require("../../../../../common/machine_learning/helpers");
var _formatted_number = require("../../../../common/components/formatted_number");
var _utils = require("../../detection_response/utils");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiTitle = (0, _styledComponents.default)(_eui.EuiTitle)`
  color: ${({
  theme: {
    eui
  }
}) => _utils.SEVERITY_COLOR.critical};
`;
const HOST_RISK_QUERY_ID = 'hostRiskScoreKpiQuery';
const USER_RISK_QUERY_ID = 'userRiskScoreKpiQuery';
const EntityAnalyticsHeader = () => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    severityCount: hostsSeverityCount,
    loading: hostRiskLoading,
    inspect: inspectHostRiskScore,
    refetch: refetchHostRiskScore
  } = (0, _risk_score.useRiskScoreKpi)({
    timerange,
    riskEntity: _search_strategy.RiskScoreEntity.host,
    filterQuery
  });
  const {
    severityCount: usersSeverityCount,
    loading: userRiskLoading,
    refetch: refetchUserRiskScore,
    inspect: inspectUserRiskScore
  } = (0, _risk_score.useRiskScoreKpi)({
    filterQuery,
    timerange,
    riskEntity: _search_strategy.RiskScoreEntity.user
  });
  const {
    data
  } = (0, _use_anomalies_search.useAggregatedAnomaliesByJob)({
    skip: false,
    from,
    to
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const [goToHostRiskTabFilteredByCritical, hostRiskTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps({
      deepLinkId: _types.SecurityPageName.hosts,
      path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.risk),
      onClick: () => {
        dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
          severitySelection: [_search_strategy.RiskSeverity.critical],
          hostsType: _model.HostsType.page
        }));
        dispatch(_store.hostsActions.updateHostRiskScoreSort({
          sort: {
            field: _search_strategy.RiskScoreFields.hostRiskScore,
            direction: _search_strategy.Direction.desc
          },
          hostsType: _model.HostsType.page
        }));
      }
    });
    return [onClick, href];
  }, [dispatch, getSecuritySolutionLinkProps]);
  const [goToUserRiskTabFilteredByCritical, userRiskTabUrl] = (0, _react.useMemo)(() => {
    const {
      onClick,
      href
    } = getSecuritySolutionLinkProps({
      deepLinkId: _types.SecurityPageName.users,
      path: (0, _redirect_to_users.getTabsOnUsersUrl)(_model2.UsersTableType.risk),
      onClick: () => {
        dispatch(_store2.usersActions.updateUserRiskScoreSeverityFilter({
          severitySelection: [_search_strategy.RiskSeverity.critical]
        }));
        dispatch(_store2.usersActions.updateTableSorting({
          sort: {
            field: _search_strategy.RiskScoreFields.userRiskScore,
            direction: _search_strategy.Direction.desc
          },
          tableType: _model2.UsersTableType.risk
        }));
      }
    });
    return [onClick, href];
  }, [dispatch, getSecuritySolutionLinkProps]);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  (0, _manage_query.useQueryInspector)({
    queryId: USER_RISK_QUERY_ID,
    loading: userRiskLoading,
    refetch: refetchUserRiskScore,
    setQuery,
    deleteQuery,
    inspect: inspectUserRiskScore
  });
  (0, _manage_query.useQueryInspector)({
    queryId: HOST_RISK_QUERY_ID,
    loading: hostRiskLoading,
    refetch: refetchHostRiskScore,
    setQuery,
    deleteQuery,
    inspect: inspectHostRiskScore
  });

  // Anomaly jobs are enabled if at least one job is started or has data
  const areJobsEnabled = (0, _react.useMemo)(() => data.some(({
    job,
    count
  }) => count > 0 || job && (0, _helpers.isJobStarted)(job.jobState, job.datafeedState)), [data]);
  const totalAnomalies = (0, _react.useMemo)(() => areJobsEnabled ? /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: (0, _fp.sumBy)('count', data)
  }) : '-', [data, areJobsEnabled]);
  const scrollToAnomalies = (0, _react.useCallback)(() => {
    const element = document.querySelector(`[data-test-subj="${_anomalies.ENTITY_ANALYTICS_ANOMALIES_PANEL}"]`);
    if (element) {
      element.scrollIntoView({
        behavior: 'smooth'
      });
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    responsive: false
  }, isPlatinumOrTrialLicense && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiTitle, {
    "data-test-subj": "critical_hosts_quantity",
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("span", null, hostsSeverityCount ? /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: hostsSeverityCount[_search_strategy.RiskSeverity.critical]
  }) : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: goToHostRiskTabFilteredByCritical,
    href: hostRiskTabUrl,
    "data-test-subj": "critical_hosts_link"
  }, i18n.CRITICAL_HOSTS)))), isPlatinumOrTrialLicense && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiTitle, {
    "data-test-subj": "critical_users_quantity",
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("span", null, usersSeverityCount ? /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: usersSeverityCount[_search_strategy.RiskSeverity.critical]
  }) : '-'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: goToUserRiskTabFilteredByCritical,
    href: userRiskTabUrl,
    "data-test-subj": "critical_users_link"
  }, i18n.CRITICAL_USERS)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "anomalies_quantity",
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("span", null, totalAnomalies))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "all_anomalies_link",
    onClick: scrollToAnomalies
  }, i18n.ANOMALIES))))));
};
exports.EntityAnalyticsHeader = EntityAnalyticsHeader;