"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCriticalAlerts = void 0;
var _react = require("react");
var _constants = require("../../../../../detections/containers/detection_engine/alerts/constants");
var _use_query = require("../../../../../detections/containers/detection_engine/alerts/use_query");
var i18n = _interopRequireWildcard(require("../translations"));
var _helpers = require("../helpers");
var _stat_reducer = require("./stat_reducer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCriticalAlertsQuery = ({
  from,
  to
}) => ({
  size: 0,
  query: {
    bool: {
      filter: [{
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      }]
    }
  },
  aggs: {
    open: {
      filter: {
        term: {
          'kibana.alert.workflow_status': 'open'
        }
      },
      aggs: {
        critical: {
          filter: {
            term: {
              'kibana.alert.severity': 'critical'
            }
          }
        }
      }
    }
  }
});
const useCriticalAlerts = ({
  from,
  fromCompare,
  skip = false,
  signalIndexName,
  to,
  toCompare
}) => {
  var _dataCurrent$aggregat3, _dataCompare$aggregat3;
  const [state, dispatch] = (0, _react.useReducer)(_stat_reducer.statReducer, {
    description: i18n.CRITICAL_ALERTS_DESCRIPTION,
    isLoading: true,
    percentage: {
      percent: null,
      color: 'hollow',
      note: i18n.NO_DATA('alerts')
    },
    stat: '-',
    testRef: 'criticalAlerts',
    title: i18n.CRITICAL_ALERTS_STAT,
    updatedAt: Date.now()
  });
  const currentTimeQuery = (0, _react.useMemo)(() => getCriticalAlertsQuery({
    from,
    to
  }), [from, to]);
  const compareTimeQuery = (0, _react.useMemo)(() => getCriticalAlertsQuery({
    from: fromCompare,
    to: toCompare
  }), [fromCompare, toCompare]);
  const {
    data: dataCurrent,
    loading: isLoadingCurrent,
    setQuery: setAlertsQueryCurrent
  } = (0, _use_query.useQueryAlerts)({
    query: currentTimeQuery,
    indexName: signalIndexName,
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.SOC_TRENDS
  });
  const {
    data: dataCompare,
    loading: isLoadingCompare,
    setQuery: setAlertsQueryCompare
  } = (0, _use_query.useQueryAlerts)({
    query: compareTimeQuery,
    indexName: signalIndexName,
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.SOC_TRENDS
  });
  (0, _react.useEffect)(() => {
    setAlertsQueryCurrent(currentTimeQuery);
  }, [currentTimeQuery, setAlertsQueryCurrent]);
  (0, _react.useEffect)(() => {
    setAlertsQueryCompare(compareTimeQuery);
  }, [compareTimeQuery, setAlertsQueryCompare]);
  (0, _react.useEffect)(() => {
    dispatch({
      type: 'setIsLoading',
      isLoading: isLoadingCurrent || isLoadingCompare
    });
  }, [isLoadingCurrent, isLoadingCompare]);
  const current = (0, _react.useMemo)(() => {
    var _dataCurrent$aggregat, _dataCurrent$aggregat2;
    return (_dataCurrent$aggregat = dataCurrent === null || dataCurrent === void 0 ? void 0 : (_dataCurrent$aggregat2 = dataCurrent.aggregations) === null || _dataCurrent$aggregat2 === void 0 ? void 0 : _dataCurrent$aggregat2.open.critical.doc_count) !== null && _dataCurrent$aggregat !== void 0 ? _dataCurrent$aggregat : null;
  }, [dataCurrent === null || dataCurrent === void 0 ? void 0 : (_dataCurrent$aggregat3 = dataCurrent.aggregations) === null || _dataCurrent$aggregat3 === void 0 ? void 0 : _dataCurrent$aggregat3.open.critical.doc_count]);
  const compare = (0, _react.useMemo)(() => {
    var _dataCompare$aggregat, _dataCompare$aggregat2;
    return (_dataCompare$aggregat = dataCompare === null || dataCompare === void 0 ? void 0 : (_dataCompare$aggregat2 = dataCompare.aggregations) === null || _dataCompare$aggregat2 === void 0 ? void 0 : _dataCompare$aggregat2.open.critical.doc_count) !== null && _dataCompare$aggregat !== void 0 ? _dataCompare$aggregat : null;
  }, [dataCompare === null || dataCompare === void 0 ? void 0 : (_dataCompare$aggregat3 = dataCompare.aggregations) === null || _dataCompare$aggregat3 === void 0 ? void 0 : _dataCompare$aggregat3.open.critical.doc_count]);
  (0, _react.useEffect)(() => {
    const percentageChange = (0, _helpers.getPercChange)(current, compare);
    if (current != null) {
      dispatch({
        type: 'setStat',
        stat: `${current}`
      });
    } else {
      dispatch({
        type: 'setStat',
        stat: '-'
      });
    }
    if (current != null && compare != null && current !== 0 && compare !== 0 && percentageChange != null) {
      const isNegative = percentageChange.charAt(0) === '-';
      const isZero = percentageChange === '0.0%';
      dispatch({
        type: 'setPercentage',
        percentage: {
          percent: isNegative || isZero ? percentageChange : `+${percentageChange}`,
          color: isZero ? 'hollow' : isNegative ? 'success' // a negative change is good
          : 'danger',
          note: isZero ? i18n.NO_CHANGE('open critical alert count') : i18n.STAT_DIFFERENCE({
            upOrDown: isNegative ? 'down' : 'up',
            percentageChange: isNegative ? percentageChange.substring(1) : percentageChange,
            stat: `${compare}`,
            statType: 'open critical alert count'
          })
        }
      });
    } else {
      const badCurrent = current == null || current === 0;
      const badCompare = compare == null || compare === 0;
      const note = badCurrent && badCompare ? i18n.NO_DATA('alerts') : badCurrent ? i18n.NO_DATA_CURRENT('alerts') : i18n.NO_DATA_COMPARE('alerts');
      dispatch({
        type: 'setPercentage',
        percentage: {
          percent: null,
          color: 'hollow',
          note
        }
      });
    }
    dispatch({
      type: 'setUpdatedAt',
      updatedAt: Date.now()
    });
  }, [current, compare]);
  return state;
};
exports.useCriticalAlerts = useCriticalAlerts;