"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogicalConditionBuilder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _condition_group = require("../condition_group");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogicalConditionBuilder = /*#__PURE__*/(0, _react.memo)(({
  entries,
  os,
  className,
  isAndDisabled = false,
  onAndClicked,
  onEntryRemove,
  onEntryChange,
  onVisited,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    className: className
  }, /*#__PURE__*/_react.default.createElement("div", null, entries.length === 0 ? /*#__PURE__*/_react.default.createElement(NoEntries, null) : /*#__PURE__*/_react.default.createElement(_condition_group.ConditionGroup, {
    os: os,
    entries: entries,
    onEntryRemove: onEntryRemove,
    onEntryChange: onEntryChange,
    onAndClicked: onAndClicked,
    isAndDisabled: isAndDisabled,
    onVisited: onVisited,
    "data-test-subj": getTestId('group1')
  })));
});
exports.LogicalConditionBuilder = LogicalConditionBuilder;
LogicalConditionBuilder.displayName = 'LogicalConditionBuilder';
const NoEntries = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.trustedapps.logicalConditionBuilder.noEntries",
    defaultMessage: "No conditions defined"
  })));
});
NoEntries.displayName = 'NoEntries';