"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_ARTIFACT_HOST_ISOLATION_EXCEPTIONS_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ARTIFACT_HOST_ISOLATION_EXCEPTIONS_LABELS = Object.freeze({
  deleteModalTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.list.removeDialog.title', {
    defaultMessage: 'Remove host isolation exception from policy'
  }),
  deleteModalImpactInfo: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.list.removeDialog.messageCallout', {
    defaultMessage: 'This host isolation exception will be removed only from this policy and can still be found and managed from the artifact page.'
  }),
  deleteModalErrorMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.list.removeDialog.errorToastTitle', {
    defaultMessage: 'Error while attempting to remove host isolation exception'
  }),
  flyoutWarningCalloutMessage: maxNumber => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.searchWarning.text', {
    defaultMessage: 'Only the first {maxNumber} host isolation exceptions are displayed. Please use the search bar to refine the results.',
    values: {
      maxNumber
    }
  }),
  flyoutNoArtifactsToBeAssignedMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.noAssignable', {
    defaultMessage: 'There are no host isolation exceptions that can be assigned to this policy.'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.title', {
    defaultMessage: 'Assign host isolation exceptions'
  }),
  flyoutSubtitle: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.subtitle', {
    defaultMessage: 'Select host isolation exceptions to add to {policyName}',
    values: {
      policyName
    }
  }),
  flyoutSearchPlaceholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.search.label', {
    defaultMessage: 'Search host isolation exceptions'
  }),
  flyoutErrorMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.toastError.text', {
    defaultMessage: `An error occurred updating host isolation exceptions`
  }),
  flyoutSuccessMessageText: updatedExceptions => updatedExceptions.length > 1 ? _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.toastSuccess.textMultiples', {
    defaultMessage: '{count} host isolation exceptions have been added to your list.',
    values: {
      count: updatedExceptions.length
    }
  }) : _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.flyout.toastSuccess.textSingle', {
    defaultMessage: '"{name}" has been added to your host isolation exception list.',
    values: {
      name: updatedExceptions[0].name
    }
  }),
  emptyUnassignedTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unassigned.title', {
    defaultMessage: 'No assigned host isolation exceptions'
  }),
  emptyUnassignedMessage: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unassigned.content', {
    defaultMessage: 'There are currently no host isolation exceptions assigned to {policyName}. Assign host isolation exceptions now or add and manage them on the host isolation exceptions page.',
    values: {
      policyName
    }
  }),
  emptyUnassignedPrimaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unassigned.primaryAction', {
    defaultMessage: 'Assign host isolation exceptions'
  }),
  emptyUnassignedSecondaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unassigned.secondaryAction', {
    defaultMessage: 'Manage host isolation exceptions'
  }),
  emptyUnassignedNoPrivilegesMessage: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unassigned.noPrivileges.content', {
    defaultMessage: 'There are currently no host isolation exceptions assigned to {policyName}.',
    values: {
      policyName
    }
  }),
  emptyUnexistingTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unexisting.title', {
    defaultMessage: 'No host isolation exceptions exist'
  }),
  emptyUnexistingMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unexisting.content', {
    defaultMessage: 'There are currently no host isolation exceptions applied to your endpoints.'
  }),
  emptyUnexistingPrimaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.empty.unexisting.action', {
    defaultMessage: 'Add host isolation exceptions'
  }),
  listTotalItemCountMessage: totalItemsCount => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.list.totalItemCount', {
    defaultMessage: 'Showing {totalItemsCount, plural, one {# host isolation exception} other {# host isolation exceptions}}',
    values: {
      totalItemsCount
    }
  }),
  listRemoveActionNotAllowedMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.list.removeActionNotAllowed', {
    defaultMessage: 'Globally applied host isolation exception cannot be removed from policy.'
  }),
  listSearchPlaceholderMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.list.search.placeholder', {
    defaultMessage: `Search on the fields below: name, description, IP`
  }),
  layoutTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.title', {
    defaultMessage: 'Assigned host isolation exceptions'
  }),
  layoutAssignButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.assignToPolicy', {
    defaultMessage: 'Assign host isolation exceptions to policy'
  }),
  layoutViewAllLinkMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.hostIsolationException.layout.about.viewAllLinkLabel', {
    defaultMessage: 'view all host isolation exceptions'
  })
});
exports.POLICY_ARTIFACT_HOST_ISOLATION_EXCEPTIONS_LABELS = POLICY_ARTIFACT_HOST_ISOLATION_EXCEPTIONS_LABELS;