"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MalwareProtectionsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _lodash = require("lodash");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _notify_user_option = require("../notify_user_option");
var _setting_card = require("../setting_card");
var _types = require("../../../../../../../../common/endpoint/types");
var _protection_setting_card_switch = require("../protection_setting_card_switch");
var _detect_prevent_protection_level = require("../detect_prevent_protection_level");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BLOCKLIST_ENABLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.blocklistEnabled', {
  defaultMessage: 'Blocklist enabled'
});
const BLOCKLIST_DISABLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.blocklistDisabled', {
  defaultMessage: 'Blocklist disabled'
});

// NOTE: it mutates `policyConfigData` passed on input
const adjustBlocklistSettingsOnProtectionSwitch = ({
  value,
  policyConfigData,
  protectionOsList
}) => {
  for (const os of protectionOsList) {
    policyConfigData[os].malware.blocklist = value;
  }
  return policyConfigData;
};
const MALWARE_OS_VALUES = [_types.PolicyOperatingSystem.windows, _types.PolicyOperatingSystem.mac, _types.PolicyOperatingSystem.linux];
/**
 * The Malware Protections form for policy details
 * which will configure for all relevant OSes.
 */
const MalwareProtectionsCard = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode = 'edit',
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const protection = 'malware';
  const selected = (policy && policy.windows[protection].mode) !== _types.ProtectionModes.off;
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.malware', {
    defaultMessage: 'Malware protections'
  });
  if (!isProtectionsAllowed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.malware', {
      defaultMessage: 'Malware'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.LINUX],
    dataTestSubj: getTestId(),
    selected: selected,
    mode: mode,
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_setting_card_switch.ProtectionSettingCardSwitch, {
      selected: selected,
      protection: protection,
      protectionLabel: protectionLabel,
      osList: MALWARE_OS_VALUES,
      additionalOnSwitchChange: adjustBlocklistSettingsOnProtectionSwitch,
      policy: policy,
      onChange: onChange,
      mode: mode,
      "data-test-subj": getTestId('enableDisableSwitch')
    })
  }, /*#__PURE__*/_react.default.createElement(_detect_prevent_protection_level.DetectPreventProtectionLevel, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: MALWARE_OS_VALUES,
    "data-test-subj": getTestId('protectionLevel')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(EnableDisableBlocklist, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    "data-test-subj": getTestId('blocklist')
  }), /*#__PURE__*/_react.default.createElement(_notify_user_option.NotifyUserOption, {
    policy: policy,
    onChange: onChange,
    mode: mode,
    protection: protection,
    osList: MALWARE_OS_VALUES,
    "data-test-subj": getTestId('notifyUser')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
});
exports.MalwareProtectionsCard = MalwareProtectionsCard;
MalwareProtectionsCard.displayName = 'MalwareProtectionsCard';
const EnableDisableBlocklist = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const checked = policy.windows.malware.blocklist;
  const isDisabled = policy.windows.malware.mode === 'off';
  const isEditMode = mode === 'edit';
  const label = checked ? BLOCKLIST_ENABLED_LABEL : BLOCKLIST_DISABLED_LABEL;
  const handleBlocklistSwitchChange = (0, _react.useCallback)(event => {
    const value = event.target.checked;
    const newPayload = (0, _lodash.cloneDeep)(policy);
    adjustBlocklistSettingsOnProtectionSwitch({
      value,
      policyConfigData: newPayload,
      protectionOsList: MALWARE_OS_VALUES
    });
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": getTestId()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: label,
    checked: checked,
    onChange: handleBlocklistSwitchChange,
    disabled: isDisabled,
    "data-test-subj": getTestId('enableDisableSwitch')
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.blocklistTooltip",
      defaultMessage: "Enables or disables the blocklist associated with this policy. The blocklist is a collection hashes, paths, or signers which extends the list of processes the endpoint considers malicious. See the blocklist tab for entry details."
    }))
  })));
});
EnableDisableBlocklist.displayName = 'EnableDisableBlocklist';