"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointGenericErrorsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../common/lib/kibana");
var _package_action_formatter = require("../../../../components/package_action_item/package_action_formatter");
var _package_action_item_error = require("../../../../components/package_action_item/package_action_item_error");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Exports Endpoint-generic errors list
 */
const EndpointGenericErrorsList = /*#__PURE__*/(0, _react.memo)(({
  packageErrors
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const globalEndpointErrors = (0, _react.useMemo)(() => {
    const errors = [];
    packageErrors.forEach(unit => {
      if (unit.status === 'FAILED' || unit.status === 'DEGRADED') {
        errors.push(new _package_action_formatter.PackageActionFormatter(unit, docLinks.links.securitySolution.packageActionTroubleshooting));
      }
    });
    return errors;
  }, [packageErrors, docLinks.links.securitySolution.packageActionTroubleshooting]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, globalEndpointErrors.map(error => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: error.key
  }, /*#__PURE__*/_react.default.createElement(_package_action_item_error.PackageActionItemError, {
    actionFormatter: error
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))));
});
exports.EndpointGenericErrorsList = EndpointGenericErrorsList;
EndpointGenericErrorsList.displayName = 'EndpointGenericErrorsList';