"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../common/constants");
var _management_page_loader = require("../../../../../components/management_page_loader");
var _use_url_params = require("../../../../../hooks/use_url_params");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _policy_hooks = require("../../policy_hooks");
var _artifacts = require("../../../../../hooks/artifacts");
var _empty = require("../empty");
var _list = require("../list");
var _flyout = require("../flyout");
var _translations = require("../translations");
var _delete_modal = require("../delete_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyArtifactsLayout = /*#__PURE__*/_react.default.memo(({
  policyItem,
  labels: _labels = {},
  getExceptionsListApiClient,
  searchableFields,
  getArtifactPath,
  getPolicyArtifactsPath,
  canWriteArtifact = false
}) => {
  const exceptionsListApiClient = (0, _react.useMemo)(() => getExceptionsListApiClient(), [getExceptionsListApiClient]);
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const navigateCallback = (0, _policy_hooks.usePolicyDetailsArtifactsNavigateCallback)(exceptionsListApiClient.listId);
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    urlParams
  } = (0, _use_url_params.useUrlParams)();
  const [exceptionItemToDelete, setExceptionItemToDelete] = (0, _react.useState)();
  const labels = (0, _react.useMemo)(() => {
    return {
      ..._translations.policyArtifactsPageLabels,
      ..._labels
    };
  }, [_labels]);
  const {
    data: allAssigned,
    isLoading: isLoadingAllAssigned
  } = (0, _artifacts.useListArtifact)(exceptionsListApiClient, {
    policies: policyItem ? [policyItem.id, 'all'] : []
  }, searchableFields);
  const {
    data: allArtifacts,
    isLoading: isLoadingAllArtifacts,
    isRefetching: isRefetchingAllArtifacts
  } = (0, _artifacts.useListArtifact)(exceptionsListApiClient, {}, searchableFields, {}, ['allExisting']);
  const handleOnClickAssignButton = (0, _react.useCallback)(() => {
    navigateCallback({
      show: 'list'
    });
  }, [navigateCallback]);
  const handleOnCloseFlyout = (0, _react.useCallback)(() => {
    navigateCallback({
      show: undefined
    });
  }, [navigateCallback]);
  const handleDeleteModalClose = (0, _react.useCallback)(() => {
    setExceptionItemToDelete(undefined);
  }, [setExceptionItemToDelete]);
  const handleOnDeleteActionCallback = (0, _react.useCallback)(item => {
    setExceptionItemToDelete(item);
  }, [setExceptionItemToDelete]);
  const assignToPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "artifacts-assign-button",
    onClick: handleOnClickAssignButton
  }, labels.layoutAssignButtonTitle), [handleOnClickAssignButton, labels.layoutAssignButtonTitle]);
  const aboutInfo = (0, _react.useMemo)(() => {
    const link = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: getAppUrl({
        appId: _constants.APP_UI_ID,
        path: getArtifactPath()
      }),
      target: "_blank"
    }, labels.layoutViewAllLinkMessage);
    return labels.layoutAboutMessage((allAssigned === null || allAssigned === void 0 ? void 0 : allAssigned.total) || 0, link);
  }, [getAppUrl, getArtifactPath, labels, allAssigned === null || allAssigned === void 0 ? void 0 : allAssigned.total]);
  const isGlobalLoading = (0, _react.useMemo)(() => isLoadingAllAssigned || isLoadingAllArtifacts || isRefetchingAllArtifacts, [isLoadingAllAssigned, isLoadingAllArtifacts, isRefetchingAllArtifacts]);
  const isEmptyState = (0, _react.useMemo)(() => allAssigned && allAssigned.total === 0, [allAssigned]);
  if (!policyItem || isGlobalLoading) {
    return /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
      "data-test-subj": "policy-artifacts-loading-spinner"
    });
  }
  if (isEmptyState) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canCreateArtifactsByPolicy && urlParams.show === 'list' && /*#__PURE__*/_react.default.createElement(_flyout.PolicyArtifactsFlyout, {
      policyItem: policyItem,
      apiClient: exceptionsListApiClient,
      searchableFields: [...searchableFields],
      onClose: handleOnCloseFlyout,
      labels: labels
    }), allArtifacts && allArtifacts.total !== 0 ? /*#__PURE__*/_react.default.createElement(_empty.PolicyArtifactsEmptyUnassigned, {
      policyId: policyItem.id,
      policyName: policyItem.name,
      listId: exceptionsListApiClient.listId,
      labels: labels,
      canWriteArtifact: canWriteArtifact,
      getPolicyArtifactsPath: getPolicyArtifactsPath,
      getArtifactPath: getArtifactPath
    }) : /*#__PURE__*/_react.default.createElement(_empty.PolicyArtifactsEmptyUnexisting, {
      policyId: policyItem.id,
      policyName: policyItem.name,
      labels: labels,
      canWriteArtifact: canWriteArtifact,
      getPolicyArtifactsPath: getPolicyArtifactsPath,
      getArtifactPath: getArtifactPath
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    "data-test-subj": "policy-artifacts-header-section"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, labels.layoutTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "policy-artifacts-layout-about"
  }, /*#__PURE__*/_react.default.createElement("p", null, aboutInfo))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, canCreateArtifactsByPolicy && canWriteArtifact && assignToPolicyButton)), canCreateArtifactsByPolicy && canWriteArtifact && urlParams.show === 'list' && /*#__PURE__*/_react.default.createElement(_flyout.PolicyArtifactsFlyout, {
    policyItem: policyItem,
    apiClient: exceptionsListApiClient,
    searchableFields: [...searchableFields],
    onClose: handleOnCloseFlyout,
    labels: labels
  }), exceptionItemToDelete && /*#__PURE__*/_react.default.createElement(_delete_modal.PolicyArtifactsDeleteModal, {
    policyId: policyItem.id,
    policyName: policyItem.name,
    apiClient: exceptionsListApiClient,
    exception: exceptionItemToDelete,
    onClose: handleDeleteModalClose,
    labels: labels
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_list.PolicyArtifactsList, {
    policy: policyItem,
    apiClient: exceptionsListApiClient,
    searchableFields: [...searchableFields],
    labels: labels,
    onDeleteActionCallback: handleOnDeleteActionCallback,
    canWriteArtifact: canWriteArtifact,
    getPolicyArtifactsPath: getPolicyArtifactsPath,
    getArtifactPath: getArtifactPath
  })));
});
exports.PolicyArtifactsLayout = PolicyArtifactsLayout;
PolicyArtifactsLayout.displayName = 'PolicyArtifactsLayout';