"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToPolicyListButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../common/lib/kibana");
var _back_to_external_app_button = require("../../../../components/back_to_external_app_button/back_to_external_app_button");
var _routing = require("../../../../common/routing");
var _common = require("../../../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BackToPolicyListButton = /*#__PURE__*/(0, _react.memo)(({
  backLink
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const backLinkOptions = (0, _react.useMemo)(() => {
    if (backLink) {
      const {
        navigateTo,
        label,
        href
      } = backLink;
      return {
        onBackButtonNavigateTo: navigateTo,
        backButtonLabel: label,
        backButtonUrl: href
      };
    }

    // the default back button is to the policy list
    const policyListPath = (0, _routing.getPoliciesPath)();
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.backToPolicyButton', {
        defaultMessage: 'Back to policy list'
      }),
      backButtonUrl: getAppUrl({
        path: policyListPath
      }),
      onBackButtonNavigateTo: [_common.APP_UI_ID, {
        path: policyListPath
      }]
    };
  }, [getAppUrl, backLink]);
  if (!backLink) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_back_to_external_app_button.BackToExternalAppButton, (0, _extends2.default)({}, backLinkOptions, {
    "data-test-subj": "endpointListBackLink"
  }));
});
exports.BackToPolicyListButton = BackToPolicyListButton;
BackToPolicyListButton.displayName = 'BackToPolicyListButton';