"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteArtifact = useDeleteArtifact;
var _reactQuery = require("@tanstack/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OPTIONS = Object.freeze({});
function useDeleteArtifact(exceptionListApiClient, customOptions = DEFAULT_OPTIONS) {
  return (0, _reactQuery.useMutation)(({
    itemId,
    id
  }) => {
    return exceptionListApiClient.delete(itemId, id);
  }, customOptions);
}