"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _link_to = require("../../../../common/components/link_to");
var _links = require("../../../../common/components/links");
var _formatted_date = require("../../../../common/components/formatted_date");
var _translations = require("../translations");
var _hooks = require("./hooks");
var _empty_value = require("../../../../common/components/empty_value");
var _response_action_status_badge = require("./response_action_status_badge");
var _action_log_expanded_tray = require("./action_log_expanded_tray");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _constants2 = require("../../../common/constants");
var _use_url_pagination = require("../../../hooks/use_url_pagination");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyValue = (0, _empty_value.getEmptyValue)();

// Truncated usernames
const StyledFacetButton = (0, _common.euiStyled)(_eui.EuiFacetButton).attrs({
  title: undefined
})`
  .euiText {
    margin-top: 0.38rem;
    overflow-y: visible !important;
  }
`;
const getResponseActionListTableColumns = ({
  getTestId,
  expandedRowMap,
  showHostNames,
  onClickCallback
}) => {
  const columns = [{
    field: 'startedAt',
    name: _translations.TABLE_COLUMN_NAMES.time,
    width: !showHostNames ? '21%' : '15%',
    truncateText: true,
    render: startedAt => {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        fieldName: _translations.TABLE_COLUMN_NAMES.time,
        value: startedAt,
        className: "eui-textTruncate"
      });
    }
  }, {
    field: 'command',
    name: _translations.TABLE_COLUMN_NAMES.command,
    width: !showHostNames ? '21%' : '10%',
    truncateText: true,
    render: _command => {
      const command = (0, _hooks.getUiCommand)(_command);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: command,
        anchorClassName: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-command')
      }, command));
    }
  }, {
    name: _translations.TABLE_COLUMN_NAMES.user,
    width: !showHostNames ? '21%' : '14%',
    truncateText: true,
    render: ({
      createdBy,
      ruleId
    }) => {
      if (createdBy === 'unknown' && ruleId) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _translations.UX_MESSAGES.triggeredByRule,
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
          "data-test-subj": "ruleName",
          deepLinkId: _constants.SecurityPageName.rules,
          path: (0, _link_to.getRuleDetailsUrl)(ruleId)
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textTruncate eui-fullWidth",
          "data-test-subj": getTestId('column-user-name')
        }, _translations.UX_MESSAGES.triggeredByRule)));
      }
      return /*#__PURE__*/_react.default.createElement(StyledFacetButton, {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar
        // We've a EuiTooltip that shows for createdBy below,
        // Thus we don't need to add a title tooltip as well.
        , {
          "aria-hidden": true,
          title: "",
          name: createdBy,
          "data-test-subj": getTestId('column-user-avatar'),
          size: "s"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: createdBy,
        anchorClassName: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-user-name')
      }, createdBy)));
    }
  },
  // conditional hostnames column
  {
    field: 'hosts',
    name: _translations.TABLE_COLUMN_NAMES.hosts,
    width: '20%',
    truncateText: true,
    render: _hosts => {
      const hosts = _hosts && Object.values(_hosts);
      // join hostnames if the action is for multiple agents
      // and skip empty strings for names if any
      const _hostnames = hosts.reduce((acc, host) => {
        if (host.name.trim()) {
          acc.push(host.name);
        }
        return acc;
      }, []).join(', ');
      let hostnames = _hostnames;
      if (!_hostnames) {
        if (hosts.length > 1) {
          // when action was for a single agent and no host name
          hostnames = _translations.UX_MESSAGES.unenrolled.hosts;
        } else if (hosts.length === 1) {
          // when action was for a multiple agents
          // and none of them have a host name
          hostnames = _translations.UX_MESSAGES.unenrolled.host;
        }
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: hostnames,
        anchorClassName: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-hostname')
      }, hostnames));
    }
  }, {
    field: 'comment',
    name: _translations.TABLE_COLUMN_NAMES.comments,
    width: !showHostNames ? '21%' : '30%',
    truncateText: true,
    render: comment => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: comment,
        anchorClassName: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        className: "eui-textTruncate eui-fullWidth",
        "data-test-subj": getTestId('column-comments')
      }, comment !== null && comment !== void 0 ? comment : emptyValue));
    }
  }, {
    field: 'status',
    name: _translations.TABLE_COLUMN_NAMES.status,
    width: !showHostNames ? '15%' : '10%',
    render: _status => {
      const status = (0, _hooks.getActionStatus)(_status);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: status,
        anchorClassName: "eui-textTruncate"
      }, /*#__PURE__*/_react.default.createElement(_response_action_status_badge.ResponseActionStatusBadge, {
        color: _status === 'failed' ? 'danger' : _status === 'successful' ? 'success' : 'warning',
        "data-test-subj": getTestId('column-status'),
        status: status
      }));
    }
  }, {
    field: '',
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _translations.UX_MESSAGES.screenReaderExpand)),
    render: actionListDataItem => {
      const actionId = actionListDataItem.id;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": getTestId('expand-button'),
        onClick: onClickCallback(actionListDataItem),
        "aria-label": expandedRowMap[actionId] ? _translations.ARIA_LABELS.collapse : _translations.ARIA_LABELS.expand,
        iconType: expandedRowMap[actionId] ? 'arrowUp' : 'arrowDown'
      });
    }
  }];
  // filter out the `hosts` column
  // if showHostNames is FALSE
  if (!showHostNames) {
    return columns.filter(column => column.field !== 'hosts');
  }
  return columns;
};
const ActionsLogTable = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj,
  error,
  items,
  isFlyout,
  loading,
  onChange,
  onShowActionDetails,
  queryParams,
  showHostNames,
  totalItemCount
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    pagination: paginationFromUrlParams
  } = (0, _use_url_pagination.useUrlPagination)();
  const [expandedRowMap, setExpandedRowMap] = (0, _react.useState)({});
  const actionIdsWithOpenTrays = (0, _react.useMemo)(() =>
  // get the list of action ids from the query params for flyout view
  queryParams.withOutputs ? typeof queryParams.withOutputs === 'string' ? [queryParams.withOutputs] : queryParams.withOutputs : [], [queryParams.withOutputs]);
  const redoOpenTrays = (0, _react.useCallback)(() => {
    if (actionIdsWithOpenTrays.length && items.length) {
      const openDetails = actionIdsWithOpenTrays.reduce((idToRowMap, actionId) => {
        const actionItem = items.find(item => item.id === actionId);
        if (!actionItem) {
          idToRowMap[actionId] = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
            size: "relative",
            lines: 8
          });
        } else {
          idToRowMap[actionId] = /*#__PURE__*/_react.default.createElement(_action_log_expanded_tray.ActionsLogExpandedTray, {
            action: actionItem,
            "data-test-subj": dataTestSubj
          });
        }
        return idToRowMap;
      }, {});
      setExpandedRowMap(openDetails);
    }
  }, [actionIdsWithOpenTrays, dataTestSubj, items]);

  // open trays that were open using URL params/ query params
  (0, _react.useEffect)(() => {
    redoOpenTrays();
  }, [redoOpenTrays]);
  const toggleDetails = (0, _react.useCallback)(action => {
    const expandedRowMapCopy = {
      ...expandedRowMap
    };
    if (expandedRowMapCopy[action.id]) {
      // close tray
      delete expandedRowMapCopy[action.id];
    } else {
      // assign the expanded tray content to the map
      // with action details
      expandedRowMapCopy[action.id] = /*#__PURE__*/_react.default.createElement(_action_log_expanded_tray.ActionsLogExpandedTray, {
        action: action,
        "data-test-subj": dataTestSubj
      });
    }
    onShowActionDetails(Object.keys(expandedRowMapCopy));
    setExpandedRowMap(expandedRowMapCopy);
  }, [expandedRowMap, onShowActionDetails, dataTestSubj]);

  // memoized callback for toggleDetails
  const onClickCallback = (0, _react.useCallback)(actionListDataItem => () => toggleDetails(actionListDataItem), [toggleDetails]);

  // table pagination
  const tablePagination = (0, _react.useMemo)(() => {
    return {
      pageIndex: isFlyout ? (queryParams.page || 1) - 1 : paginationFromUrlParams.page - 1,
      pageSize: isFlyout ? queryParams.pageSize || 10 : paginationFromUrlParams.pageSize,
      totalItemCount,
      pageSizeOptions: _constants2.MANAGEMENT_PAGE_SIZE_OPTIONS
    };
  }, [isFlyout, paginationFromUrlParams.page, paginationFromUrlParams.pageSize, queryParams.page, queryParams.pageSize, totalItemCount]);

  // compute record ranges
  const pagedResultsCount = (0, _react.useMemo)(() => {
    var _queryParams$page, _queryParams$pageSize;
    const page = (_queryParams$page = queryParams.page) !== null && _queryParams$page !== void 0 ? _queryParams$page : 1;
    const perPage = (_queryParams$pageSize = queryParams === null || queryParams === void 0 ? void 0 : queryParams.pageSize) !== null && _queryParams$pageSize !== void 0 ? _queryParams$pageSize : 10;
    const totalPages = Math.ceil(totalItemCount / perPage);
    const fromCount = perPage * page - perPage + 1;
    const toCount = page === totalPages || totalPages === 1 ? totalItemCount : fromCount + perPage - 1;
    return {
      fromCount,
      toCount
    };
  }, [queryParams.page, queryParams.pageSize, totalItemCount]);

  // create range label to display
  const recordRangeLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "xs",
    "data-test-subj": getTestId('endpointListTableTotal')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActionsList.list.recordRange",
    defaultMessage: "Showing {range} of {total} {recordsLabel}",
    values: {
      range: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: pagedResultsCount.fromCount
      }), '-', /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: pagedResultsCount.toCount
      })),
      total: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: totalItemCount
      }),
      recordsLabel: /*#__PURE__*/_react.default.createElement("strong", null, _translations.UX_MESSAGES.recordsLabel(totalItemCount))
    }
  })), [getTestId, pagedResultsCount.fromCount, pagedResultsCount.toCount, totalItemCount]);
  const columns = (0, _react.useMemo)(() => getResponseActionListTableColumns({
    getTestId,
    expandedRowMap,
    onClickCallback,
    showHostNames
  }), [expandedRowMap, getTestId, onClickCallback, showHostNames]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, recordRangeLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": dataTestSubj,
    items: items,
    columns: columns,
    itemId: "id",
    itemIdToExpandedRowMap: expandedRowMap,
    isExpandable: true,
    pagination: tablePagination,
    onChange: onChange,
    loading: loading,
    error: error
  }));
});
exports.ActionsLogTable = ActionsLogTable;
ActionsLogTable.displayName = 'ActionsLogTable';