"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformIcon = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _linux = _interopRequireDefault(require("./logos/linux.svg"));
var _windows = _interopRequireDefault(require("./logos/windows.svg"));
var _macos = _interopRequireDefault(require("./logos/macos.svg"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPlatformIcon = platform => {
  switch (platform) {
    case 'macos':
      return _macos.default;
    case 'linux':
      return _linux.default;
    case 'windows':
      return _windows.default;
    default:
      return null;
  }
};
const PlatformIcon = /*#__PURE__*/(0, _react.memo)(({
  platform,
  size = 'xl',
  'data-test-subj': dataTestSubj
}) => {
  const platformIcon = (0, _react.useMemo)(() => getPlatformIcon(platform), [platform]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: !platformIcon ? 'empty' : platformIcon,
    title: platform,
    size: size,
    "data-test-subj": dataTestSubj
  });
});
exports.PlatformIcon = PlatformIcon;
PlatformIcon.displayName = 'PlatformIcon';