"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _classnames = _interopRequireDefault(require("classnames"));
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiPanelStyled = (0, _styledComponents.default)(_eui.EuiPanel)`
  &.full-height,
  .full-height {
    height: 100%;
  }

  .is-not-scrollable {
    overflow: hidden;
  }

  .is-scrollable {
    overflow: auto;
  }
`;
const PageLayout = /*#__PURE__*/(0, _react.memo)(({
  pageTitle,
  pageDescription,
  pageBody,
  actions,
  headerHasBottomBorder,
  restrictWidth,
  paddingSize = 'l',
  scrollableBody = false,
  headerBackComponent,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const hideHeader = !pageTitle && !pageDescription && !actions && !headerBackComponent;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const headerRightSideItems = (0, _react.useMemo)(() => {
    return Array.isArray(actions) ? actions : actions ? [actions] : undefined;
  }, [actions]);
  const headerRightSideGroupProps = (0, _react.useMemo)(() => {
    return {
      gutterSize: 's'
    };
  }, []);
  const consoleBodyClassName = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'is-scrollable': scrollableBody,
      'is-not-scrollable': !scrollableBody,
      'full-height': true
    });
  }, [scrollableBody]);
  const headerTitleContainer = (0, _react.useMemo)(() => {
    return hideHeader ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      alignItems: "flexStart",
      wrap: false,
      responsive: false
    }, headerBackComponent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, headerBackComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": getTestId('titleHolder')
    }, pageTitle))));
  }, [getTestId, headerBackComponent, hideHeader, pageTitle]);
  return /*#__PURE__*/_react.default.createElement(EuiPanelStyled, {
    hasShadow: false,
    paddingSize: paddingSize,
    "data-test-subj": dataTestSubj,
    className: "full-height",
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    className: "full-height",
    "data-test-subj": getTestId('root')
  }, !hideHeader && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('headerContainer')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: headerTitleContainer,
    description: pageDescription,
    bottomBorder: headerHasBottomBorder,
    rightSideItems: headerRightSideItems,
    rightSideGroupProps: headerRightSideGroupProps,
    restrictWidth: restrictWidth,
    alignItems: "bottom",
    "data-test-subj": getTestId('header')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, pageBody), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: consoleBodyClassName,
    "data-test-subj": getTestId('consoleBody')
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "main",
    className: "full-height"
  }, children))));
});
exports.PageLayout = PageLayout;
PageLayout.displayName = 'PageLayout';