"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE = exports.MANAGEMENT_STORE_GLOBAL_NAMESPACE = exports.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE = exports.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH = exports.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH = exports.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH = exports.MANAGEMENT_ROUTING_POLICIES_PATH = exports.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH = exports.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH = exports.MANAGEMENT_ROUTING_ENDPOINTS_PATH = exports.MANAGEMENT_ROUTING_BLOCKLIST_PATH = exports.MANAGEMENT_PAGE_SIZE_OPTIONS = exports.MANAGEMENT_DEFAULT_SORT_ORDER = exports.MANAGEMENT_DEFAULT_SORT_FIELD = exports.MANAGEMENT_DEFAULT_PAGE_SIZE = exports.MANAGEMENT_DEFAULT_PAGE = exports.DEFAULT_POLL_INTERVAL = void 0;
var _constants = require("../../../common/constants");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// --[ ROUTING ]---------------------------------------------------------------------------
const MANAGEMENT_ROUTING_ENDPOINTS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.endpoints})`;
exports.MANAGEMENT_ROUTING_ENDPOINTS_PATH = MANAGEMENT_ROUTING_ENDPOINTS_PATH;
const MANAGEMENT_ROUTING_POLICIES_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})`;
exports.MANAGEMENT_ROUTING_POLICIES_PATH = MANAGEMENT_ROUTING_POLICIES_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/settings`;
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH = MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/trustedApps`;
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH = MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/eventFilters`;
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH = MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/hostIsolationExceptions`;
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH = MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/blocklists`;
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH = MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId/protectionUpdates`;
/** @deprecated use the paths defined above instead */
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH = MANAGEMENT_ROUTING_POLICY_DETAILS_PROTECTION_UPDATES_PATH;
const MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.policies})/:policyId`;
exports.MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD = MANAGEMENT_ROUTING_POLICY_DETAILS_PATH_OLD;
const MANAGEMENT_ROUTING_TRUSTED_APPS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.trustedApps})`;
exports.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH = MANAGEMENT_ROUTING_TRUSTED_APPS_PATH;
const MANAGEMENT_ROUTING_EVENT_FILTERS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.eventFilters})`;
exports.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH = MANAGEMENT_ROUTING_EVENT_FILTERS_PATH;
const MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.hostIsolationExceptions})`;
exports.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH = MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH;
const MANAGEMENT_ROUTING_BLOCKLIST_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.blocklist})`;
exports.MANAGEMENT_ROUTING_BLOCKLIST_PATH = MANAGEMENT_ROUTING_BLOCKLIST_PATH;
const MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH = `${_constants.MANAGEMENT_PATH}/:tabName(${_types.AdministrationSubTab.responseActionsHistory})`;

// --[ STORE ]---------------------------------------------------------------------------
/** The SIEM global store namespace where the management state will be mounted */
exports.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH = MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH;
const MANAGEMENT_STORE_GLOBAL_NAMESPACE = 'management';
/** Namespace within the Management state where policy details state is maintained */
exports.MANAGEMENT_STORE_GLOBAL_NAMESPACE = MANAGEMENT_STORE_GLOBAL_NAMESPACE;
const MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE = 'policyDetails';
/** Namespace within the Management state where endpoint-host state is maintained */
exports.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE = MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE;
const MANAGEMENT_STORE_ENDPOINTS_NAMESPACE = 'endpoints';
exports.MANAGEMENT_STORE_ENDPOINTS_NAMESPACE = MANAGEMENT_STORE_ENDPOINTS_NAMESPACE;
const MANAGEMENT_PAGE_SIZE_OPTIONS = [10, 20, 50];
exports.MANAGEMENT_PAGE_SIZE_OPTIONS = MANAGEMENT_PAGE_SIZE_OPTIONS;
const MANAGEMENT_DEFAULT_PAGE = 0;
exports.MANAGEMENT_DEFAULT_PAGE = MANAGEMENT_DEFAULT_PAGE;
const MANAGEMENT_DEFAULT_PAGE_SIZE = 10;
exports.MANAGEMENT_DEFAULT_PAGE_SIZE = MANAGEMENT_DEFAULT_PAGE_SIZE;
const MANAGEMENT_DEFAULT_SORT_ORDER = 'desc';
exports.MANAGEMENT_DEFAULT_SORT_ORDER = MANAGEMENT_DEFAULT_SORT_ORDER;
const MANAGEMENT_DEFAULT_SORT_FIELD = 'created_at';

// --[ DEFAULTS ]---------------------------------------------------------------------------
/** The default polling interval to start all polling pages */
exports.MANAGEMENT_DEFAULT_SORT_FIELD = MANAGEMENT_DEFAULT_SORT_FIELD;
const DEFAULT_POLL_INTERVAL = 10000;
exports.DEFAULT_POLL_INTERVAL = DEFAULT_POLL_INTERVAL;