"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskInputActionsPanels = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/cases-plugin/common");
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_risk_input_actions = require("./use_risk_input_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskInputActionsPanels = (alerts, closePopover) => {
  const {
    cases: casesService
  } = (0, _public.useKibana)().services;
  const {
    addToExistingCase,
    addToNewCaseClick,
    addToNewTimeline
  } = (0, _use_risk_input_actions.useRiskInputActions)(alerts, closePopover);
  const userCasesPermissions = casesService === null || casesService === void 0 ? void 0 : casesService.helpers.canUseCases([_common.SECURITY_SOLUTION_OWNER]);
  const hasCasesPermissions = (userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.create) && (userCasesPermissions === null || userCasesPermissions === void 0 ? void 0 : userCasesPermissions.read);
  return (0, _react.useMemo)(() => {
    var _get;
    const timelinePanel = {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actions.addToNewTimeline",
        defaultMessage: "Add to new timeline"
      }),
      onClick: addToNewTimeline
    };
    const ruleName = (_get = (0, _fp.get)(['fields', _ruleDataUtils.ALERT_RULE_NAME], alerts[0])) !== null && _get !== void 0 ? _get : [''];
    const title = _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.actions.title', {
      defaultMessage: 'Risk input: {description}',
      values: {
        description: alerts.length === 1 ? ruleName[0] : _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.riskInputs.actions.titleDescription', {
          defaultMessage: '{quantity} selected',
          values: {
            quantity: alerts.length
          }
        })
      }
    });
    return [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        width: 230 // It prevents the title from taking too much space
        ,
        text: title
      }),
      id: 0,
      items: hasCasesPermissions ? [timelinePanel, {
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actions.addToNewCase",
          defaultMessage: "Add to new case"
        }),
        onClick: addToNewCaseClick
      }, {
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actions.addToExistingCase",
          defaultMessage: "Add to existing case"
        }),
        onClick: addToExistingCase
      }] : [timelinePanel]
    }];
  }, [addToExistingCase, addToNewCaseClick, addToNewTimeline, alerts, hasCasesPermissions]);
};
exports.useRiskInputActionsPanels = useRiskInputActionsPanels;