"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _json_tab = require("./tabs/json_tab");
var _overview_tab = require("./tabs/overview_tab");
var _table_tab = require("./tabs/table_tab");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Tabs to display in the document details expandable flyout right section
 */
const tabs = [{
  id: 'overview',
  'data-test-subj': _test_ids.OVERVIEW_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.overviewTabLabel",
    defaultMessage: "Overview"
  }),
  content: /*#__PURE__*/_react.default.createElement(_overview_tab.OverviewTab, null)
}, {
  id: 'table',
  'data-test-subj': _test_ids.TABLE_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.tableTabLabel",
    defaultMessage: "Table"
  }),
  content: /*#__PURE__*/_react.default.createElement(_table_tab.TableTab, null)
}, {
  id: 'json',
  'data-test-subj': _test_ids.JSON_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.jsonTabLabel",
    defaultMessage: "JSON"
  }),
  content: /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, null)
}];
exports.tabs = tabs;