"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_show_related_alerts_by_session = require("../../shared/hooks/use_show_related_alerts_by_session");
var _related_alerts_by_session = require("./related_alerts_by_session");
var _use_show_related_alerts_by_same_source_event = require("../../shared/hooks/use_show_related_alerts_by_same_source_event");
var _related_alerts_by_same_source_event = require("./related_alerts_by_same_source_event");
var _related_alerts_by_ancestry = require("./related_alerts_by_ancestry");
var _use_show_related_alerts_by_ancestry = require("../../shared/hooks/use_show_related_alerts_by_ancestry");
var _suppressed_alerts = require("./suppressed_alerts");
var _use_show_suppressed_alerts = require("../../shared/hooks/use_show_suppressed_alerts");
var _related_cases = require("./related_cases");
var _use_show_related_cases = require("../../shared/hooks/use_show_related_cases");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _left = require("../../left");
var _correlations_details = require("../../left/components/correlations_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Correlations section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const CorrelationsOverview = () => {
  const {
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    eventId,
    indexName,
    getFieldsData,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const goToCorrelationsTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _correlations_details.CORRELATIONS_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    show: showAlertsByAncestry,
    documentId,
    indices
  } = (0, _use_show_related_alerts_by_ancestry.useShowRelatedAlertsByAncestry)({
    getFieldsData,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    eventId,
    isPreview
  });
  const {
    show: showSameSourceAlerts,
    originalEventId
  } = (0, _use_show_related_alerts_by_same_source_event.useShowRelatedAlertsBySameSourceEvent)({
    getFieldsData
  });
  const {
    show: showAlertsBySession,
    entityId
  } = (0, _use_show_related_alerts_by_session.useShowRelatedAlertsBySession)({
    getFieldsData
  });
  const showCases = (0, _use_show_related_cases.useShowRelatedCases)();
  const {
    show: showSuppressedAlerts,
    alertSuppressionCount
  } = (0, _use_show_suppressed_alerts.useShowSuppressedAlerts)({
    getFieldsData
  });
  const canShowAtLeastOneInsight = showAlertsByAncestry || showSameSourceAlerts || showAlertsBySession || showCases || showSuppressedAlerts;
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.correlations.overviewTitle",
        defaultMessage: "Correlations"
      }),
      link: {
        callback: goToCorrelationsTab,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.insights.correlations.overviewTooltip",
          defaultMessage: "Show all correlations"
        })
      },
      iconType: 'arrowStart'
    },
    "data-test-subj": _test_ids.CORRELATIONS_TEST_ID
  }, canShowAtLeastOneInsight ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, showSuppressedAlerts && /*#__PURE__*/_react.default.createElement(_suppressed_alerts.SuppressedAlerts, {
    alertSuppressionCount: alertSuppressionCount
  }), showCases && /*#__PURE__*/_react.default.createElement(_related_cases.RelatedCases, {
    eventId: eventId
  }), showSameSourceAlerts && originalEventId && /*#__PURE__*/_react.default.createElement(_related_alerts_by_same_source_event.RelatedAlertsBySameSourceEvent, {
    originalEventId: originalEventId,
    scopeId: scopeId
  }), showAlertsBySession && entityId && /*#__PURE__*/_react.default.createElement(_related_alerts_by_session.RelatedAlertsBySession, {
    entityId: entityId,
    scopeId: scopeId
  }), showAlertsByAncestry && documentId && indices && /*#__PURE__*/_react.default.createElement(_related_alerts_by_ancestry.RelatedAlertsByAncestry, {
    documentId: documentId,
    indices: indices,
    scopeId: scopeId
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.noDataDescription",
    defaultMessage: "No correlations data available."
  }));
};
exports.CorrelationsOverview = CorrelationsOverview;
CorrelationsOverview.displayName = 'CorrelationsOverview';