"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerPreviewContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _use_investigate_in_timeline = require("../../../../detections/components/alerts_table/timeline_actions/use_investigate_in_timeline");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _helpers = require("../../../../helpers");
var _actions = require("../../../../timelines/store/timeline/actions");
var _context = require("../context");
var _investigate_in_resolver = require("../../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _analyzer_preview = require("./analyzer_preview");
var _test_ids = require("./test_ids");
var _expandable_panel = require("../../../shared/components/expandable_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineId = 'timeline-1';

/**
 * Analyzer preview under Overview, Visualizations. It shows a tree representation of analyzer.
 */
const AnalyzerPreviewContainer = () => {
  const {
    dataAsNestedObject,
    isPreview
  } = (0, _context.useRightPanelContext)();

  // decide whether to show the analyzer preview or not
  const isEnabled = (0, _investigate_in_resolver.useIsInvestigateInResolverActionEnabled)(dataAsNestedObject);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    investigateInTimelineAlertClick
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    ecsRowData: dataAsNestedObject
  });

  // open timeline to the analyzer tab because the expandable flyout left panel Visualize => Analyzer tab is not ready
  const goToAnalyzerTab = (0, _react.useCallback)(() => {
    // open timeline
    investigateInTimelineAlertClick();

    // open analyzer tab
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.OPEN_ANALYZER
    });
    const scopedActions = (0, _helpers.getScopedActions)(timelineId);
    if (scopedActions && dataAsNestedObject) {
      dispatch(scopedActions.updateGraphEventId({
        id: timelineId,
        graphEventId: dataAsNestedObject._id
      }));
    }
    dispatch((0, _actions.setActiveTabTimeline)({
      id: timelineId,
      activeTab: _securitysolutionDataTable.TimelineTabs.graph
    }));
  }, [dataAsNestedObject, dispatch, investigateInTimelineAlertClick, startTransaction]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.analyzerPreview.analyzerPreviewTitle",
        defaultMessage: "Analyzer preview"
      }),
      iconType: 'timeline',
      ...(isEnabled && !isPreview && {
        link: {
          callback: goToAnalyzerTab,
          tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.flyout.right.visualizations.analyzerPreview.analyzerPreviewTooltip",
            defaultMessage: "Show analyzer graph"
          })
        }
      })
    },
    "data-test-subj": _test_ids.ANALYZER_PREVIEW_TEST_ID
  }, isEnabled ? /*#__PURE__*/_react.default.createElement(_analyzer_preview.AnalyzerPreview, null) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.visualizations.analyzerPreview.noDataDescription",
    defaultMessage: "You can only visualize events triggered by hosts configured with the Elastic Defend integration or any {sysmon} data from {winlogbeat}. Refer to {link} for more information.",
    values: {
      sysmon: /*#__PURE__*/_react.default.createElement(_eui.EuiMark, null, 'sysmon'),
      winlogbeat: /*#__PURE__*/_react.default.createElement(_eui.EuiMark, null, 'winlogbeat'),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/visual-event-analyzer.html",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.analyzerPreview.noDataLinkText",
        defaultMessage: "Visual event analyzer"
      }))
    }
  }));
};
exports.AnalyzerPreviewContainer = AnalyzerPreviewContainer;
AnalyzerPreviewContainer.displayName = 'AnalyzerPreviewContainer';