"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _ = require("..");
var _entities_details = require("../components/entities_details");
var _threat_intelligence_details = require("../components/threat_intelligence_details");
var _prevalence_details = require("../components/prevalence_details");
var _correlations_details = require("../components/correlations_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insightsButtons = [{
  id: _entities_details.ENTITIES_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entitiesButtonLabel",
    defaultMessage: "Entities"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_ENTITIES_BUTTON_TEST_ID
}, {
  id: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.threatIntelligenceButtonLabel",
    defaultMessage: "Threat intelligence"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_THREAT_INTELLIGENCE_BUTTON_TEST_ID
}, {
  id: _prevalence_details.PREVALENCE_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalenceButtonLabel",
    defaultMessage: "Prevalence"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_PREVALENCE_BUTTON_TEST_ID
}, {
  id: _correlations_details.CORRELATIONS_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlationsButtonLabel",
    defaultMessage: "Correlations"
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_CORRELATIONS_BUTTON_TEST_ID
}];

/**
 * Insights view displayed in the document details expandable flyout left section
 */
const InsightsTab = /*#__PURE__*/(0, _react.memo)(() => {
  var _panels$left$path$sub, _panels$left, _panels$left$path;
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useLeftPanelContext)();
  const {
    openLeftPanel,
    panels
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const activeInsightsId = (_panels$left$path$sub = (_panels$left = panels.left) === null || _panels$left === void 0 ? void 0 : (_panels$left$path = _panels$left.path) === null || _panels$left$path === void 0 ? void 0 : _panels$left$path.subTab) !== null && _panels$left$path$sub !== void 0 ? _panels$left$path$sub : _entities_details.ENTITIES_TAB_ID;
  const onChangeCompressed = (0, _react.useCallback)(optionId => {
    openLeftPanel({
      id: _.DocumentDetailsLeftPanelKey,
      path: {
        tab: _.LeftPanelInsightsTab,
        subTab: optionId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, scopeId, openLeftPanel]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    name: "coarsness",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.buttonGroupLegendLabel', {
      defaultMessage: 'Insights options'
    }),
    options: insightsButtons,
    idSelected: activeInsightsId,
    onChange: onChangeCompressed,
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.INSIGHTS_TAB_BUTTON_GROUP_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), activeInsightsId === _entities_details.ENTITIES_TAB_ID && /*#__PURE__*/_react.default.createElement(_entities_details.EntitiesDetails, null), activeInsightsId === _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_threat_intelligence_details.ThreatIntelligenceDetails, null), activeInsightsId === _prevalence_details.PREVALENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_prevalence_details.PrevalenceDetails, null), activeInsightsId === _correlations_details.CORRELATIONS_TAB_ID && /*#__PURE__*/_react.default.createElement(_correlations_details.CorrelationsDetails, null));
});
exports.InsightsTab = InsightsTab;
InsightsTab.displayName = 'InsightsTab';