"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _visualize_tab = require("./tabs/visualize_tab");
var _investigation_tab = require("./tabs/investigation_tab");
var _insights_tab = require("./tabs/insights_tab");
var _test_ids = require("./test_ids");
var _response_tab = require("./tabs/response_tab");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabs = [{
  id: 'visualize',
  'data-test-subj': _test_ids.VISUALIZE_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.visualize.tabLabel",
    defaultMessage: "Visualize"
  }),
  content: /*#__PURE__*/_react.default.createElement(_visualize_tab.VisualizeTab, null),
  visible: false
}, {
  id: 'insights',
  'data-test-subj': _test_ids.INSIGHTS_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.tabLabel",
    defaultMessage: "Insights"
  }),
  content: /*#__PURE__*/_react.default.createElement(_insights_tab.InsightsTab, null),
  visible: true
}, {
  id: 'investigation',
  'data-test-subj': _test_ids.INVESTIGATION_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.investigations.tabLabel",
    defaultMessage: "Investigation"
  }),
  content: /*#__PURE__*/_react.default.createElement(_investigation_tab.InvestigationTab, null),
  visible: true
}, {
  id: 'response',
  'data-test-subj': _test_ids.RESPONSE_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.response.tabLabel",
    defaultMessage: "Response"
  }),
  content: /*#__PURE__*/_react.default.createElement(_response_tab.ResponseTab, null),
  visible: true
}];
exports.tabs = tabs;