"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columns = exports.TIMESTAMP_DATE_FORMAT = exports.CorrelationsDetailsAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _Either = require("fp-ts/lib/Either");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _cell_tooltip_wrapper = require("../../shared/components/cell_tooltip_wrapper");
var _severity_badge = require("../../../../detections/components/rules/severity_badge");
var _use_paginated_alerts = require("../hooks/use_paginated_alerts");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _investigate_in_timeline_button = require("../../../../common/components/event_details/table/investigate_in_timeline_button");
var _translations = require("../../../../detections/components/alerts_table/translations");
var _use_action_cell_data_provider = require("../../../../common/components/event_details/table/use_action_cell_data_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIMESTAMP_DATE_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
exports.TIMESTAMP_DATE_FORMAT = TIMESTAMP_DATE_FORMAT;
const dataProviderLimit = 5;
const columns = [{
  field: '@timestamp',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.timestampColumnLabel",
    defaultMessage: "Timestamp"
  }),
  truncateText: true,
  dataType: 'date',
  render: value => {
    const date = (0, _eui.formatDate)(value, TIMESTAMP_DATE_FORMAT);
    return /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
      tooltip: date
    }, /*#__PURE__*/_react.default.createElement("span", null, date));
  }
}, {
  field: _ruleDataUtils.ALERT_RULE_NAME,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.ruleColumnLabel",
    defaultMessage: "Rule"
  }),
  truncateText: true,
  render: value => /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
    tooltip: value
  }, /*#__PURE__*/_react.default.createElement("span", null, value))
}, {
  field: _ruleDataUtils.ALERT_REASON,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.reasonColumnLabel",
    defaultMessage: "Reason"
  }),
  truncateText: true,
  render: value => /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
    tooltip: value,
    anchorPosition: "left"
  }, /*#__PURE__*/_react.default.createElement("span", null, value))
}, {
  field: 'kibana.alert.severity',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.severityColumnLabel",
    defaultMessage: "Severity"
  }),
  truncateText: true,
  render: value => {
    const decodedSeverity = _securitysolutionIoTsAlertingTypes.Severity.decode(value);
    const renderValue = (0, _Either.isRight)(decodedSeverity) ? /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: decodedSeverity.right
    }) : /*#__PURE__*/_react.default.createElement("p", null, value);
    return /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
      tooltip: value
    }, renderValue);
  }
}];
exports.columns = columns;
/**
 * Renders paginated alert array based on the provided alertIds
 */
const CorrelationsDetailsAlertsTable = ({
  title,
  loading,
  alertIds,
  scopeId,
  eventId,
  noItemsMessage,
  'data-test-subj': dataTestSubj
}) => {
  const {
    setPagination,
    setSorting,
    data,
    loading: alertsLoading,
    paginationConfig,
    sorting,
    error
  } = (0, _use_paginated_alerts.usePaginatedAlerts)(alertIds || []);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      const {
        index: pageIndex,
        size: pageSize
      } = page;
      setPagination({
        pageIndex,
        pageSize
      });
    }
    if (sort) {
      setSorting(sort);
    }
  }, [setPagination, setSorting]);
  const mappedData = (0, _react.useMemo)(() => {
    return data.map(hit => hit.fields).map((fields = {}) => Object.keys(fields).reduce((result, fieldName) => {
      var _fields$fieldName;
      result[fieldName] = (fields === null || fields === void 0 ? void 0 : (_fields$fieldName = fields[fieldName]) === null || _fields$fieldName === void 0 ? void 0 : _fields$fieldName[0]) || (fields === null || fields === void 0 ? void 0 : fields[fieldName]);
      return result;
    }, {}));
  }, [data]);
  const shouldUseFilters = Boolean(alertIds && alertIds.length && alertIds.length >= dataProviderLimit);
  const dataProviders = (0, _react.useMemo)(() => shouldUseFilters ? null : getDataProviders(scopeId, eventId, alertIds), [alertIds, shouldUseFilters, scopeId, eventId]);
  const filters = (0, _react.useMemo)(() => shouldUseFilters ? getFilters(alertIds) : null, [alertIds, shouldUseFilters]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title,
      iconType: 'warning',
      headerContent: alertIds && alertIds.length && alertIds.length > 0 ? /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": `${dataTestSubj}InvestigateInTimeline`
      }, /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
        dataProviders: dataProviders,
        filters: filters,
        asEmptyButton: true,
        iconType: "timeline"
      }, _translations.ACTION_INVESTIGATE_IN_TIMELINE)) : null
    },
    content: {
      error
    },
    expand: {
      expandable: true,
      expandedOnFirstRender: true
    },
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `${dataTestSubj}Table`,
    loading: loading || alertsLoading,
    items: mappedData,
    columns: columns,
    pagination: paginationConfig,
    sorting: sorting,
    onChange: onTableChange,
    noItemsMessage: noItemsMessage
  }));
};
exports.CorrelationsDetailsAlertsTable = CorrelationsDetailsAlertsTable;
const getFilters = alertIds => {
  if (alertIds && alertIds.length) {
    return [{
      meta: {
        alias: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.correlations.tableFilterLabel', {
          defaultMessage: 'Correlations Details Table Alert IDs.'
        }),
        type: 'phrases',
        key: '_id',
        params: [...alertIds],
        negate: false,
        disabled: false,
        value: alertIds.join()
      },
      query: {
        bool: {
          should: alertIds.map(id => {
            return {
              match_phrase: {
                _id: id
              }
            };
          }),
          minimum_should_match: 1
        }
      }
    }];
  }
  return null;
};
const getDataProviders = (scopeId, eventId, alertIds) => {
  if (alertIds && alertIds.length) {
    return alertIds.reduce((result, alertId, index) => {
      const id = `${scopeId}-${eventId}-event.id-${index}-${alertId}`;
      result.push((0, _use_action_cell_data_provider.getDataProvider)('_id', id, alertId));
      return result;
    }, []);
  }
  return null;
};