"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeGraph = exports.ANALYZE_GRAPH_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("../context");
var _test_ids = require("./test_ids");
var _view = require("../../../../resolver/view");
var _use_timeline_data_filters = require("../../../../timelines/containers/use_timeline_data_filters");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYZE_GRAPH_ID = 'analyze_graph';

/**
 * Analyzer graph view displayed in the document details expandable flyout left section under the Visualize tab
 */
exports.ANALYZE_GRAPH_ID = ANALYZE_GRAPH_ID;
const AnalyzeGraph = () => {
  const {
    eventId
  } = (0, _context.useLeftPanelContext)();
  const scopeId = 'flyout'; // Different scope Id to distinguish flyout and data table analyzers
  const {
    from,
    to,
    shouldUpdate,
    selectedPatterns
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(scopeId));
  const filters = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);

  // TODO as part of https://github.com/elastic/security-team/issues/7032
  //  bring back no data message if needed

  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ANALYZER_GRAPH_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_view.Resolver, {
    databaseDocumentID: eventId,
    resolverComponentInstanceID: scopeId,
    indices: selectedPatterns,
    shouldUpdate: shouldUpdate,
    filters: filters
  }));
};
exports.AnalyzeGraph = AnalyzeGraph;
AnalyzeGraph.displayName = 'AnalyzeGraph';