"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _translations = require("../../../timelines/components/side_panel/event_details/translations");
var _context = require("./context");
var _test_ids = require("./test_ids");
var _flyout_header = require("../../shared/components/flyout_header");
var _sentinelone_alert_check = require("../../../common/utils/sentinelone_alert_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details expandable right section header for the isolate host panel
 */
const PanelHeader = () => {
  const {
    isolateAction,
    dataFormattedForFieldBrowser: data
  } = (0, _context.useIsolateHostPanelContext)();
  const isSentinelOneAlert = (0, _sentinelone_alert_check.isAlertFromSentinelOneEvent)({
    data
  });
  const sentinelOneManualHostActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isolateAction === 'isolateHost' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.isolateHost.isolateTitle",
    defaultMessage: "Isolate host"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.isolateHost.releaseTitle",
    defaultMessage: "Release host"
  })), sentinelOneManualHostActionsEnabled && isSentinelOneAlert && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.TECHNICAL_PREVIEW,
    tooltipContent: _translations.TECHNICAL_PREVIEW_DESCRIPTION
  })));
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID
  }, title)));
};
exports.PanelHeader = PanelHeader;