"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistUserAssetTableInStorage = exports.getUserAssetTableFromStorage = exports.LOCAL_STORAGE_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = 'securityUserFlyoutAssetTable';
exports.LOCAL_STORAGE_KEY = LOCAL_STORAGE_KEY;
const getUserAssetTableFromStorage = storage => storage.get(LOCAL_STORAGE_KEY);
exports.getUserAssetTableFromStorage = getUserAssetTableFromStorage;
const persistUserAssetTableInStorage = (storage, id, table) => {
  const tables = storage.get(LOCAL_STORAGE_KEY);
  storage.set(LOCAL_STORAGE_KEY, {
    ...tables,
    [id]: table
  });
};
exports.persistUserAssetTableInStorage = persistUserAssetTableInStorage;