"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_USERS_BY_SEVERITY = exports.USER_RISK_SCORE = exports.USER_NAME = exports.UNIT = exports.ROWS_5 = exports.ROWS_10 = exports.LAST_UPDATED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_NAME = _i18n.i18n.translate('xpack.securitySolution.usersRiskTable.userNameTitle', {
  defaultMessage: 'User Name'
});
exports.USER_NAME = USER_NAME;
const USER_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.usersRiskTable.userRiskScoreTitle', {
  defaultMessage: 'User risk score'
});
exports.USER_RISK_SCORE = USER_RISK_SCORE;
const VIEW_USERS_BY_SEVERITY = severity => _i18n.i18n.translate('xpack.securitySolution.usersRiskTable.filteredUsersTitle', {
  values: {
    severity
  },
  defaultMessage: 'View {severity} risk users'
});
exports.VIEW_USERS_BY_SEVERITY = VIEW_USERS_BY_SEVERITY;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.usersTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {user} other {users}}`
});
exports.UNIT = UNIT;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.usersTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.usersTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;
const LAST_UPDATED = _i18n.i18n.translate('xpack.securitySolution.usersTable.lastUpdatedTitle', {
  defaultMessage: 'Last updated'
});
exports.LAST_UPDATED = LAST_UPDATED;