"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsNetworkDetails = void 0;
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnNetworkDetailsUrl = (ipAddress, tabName, flowTarget) => `${_constants.NETWORK_PATH}/ip/${ipAddress}/${flowTarget}/${tabName}`;
const navTabsNetworkDetails = (ipAddress, hasMlUserPermissions, flowTarget) => {
  const networkDetailsNavTabs = {
    [_types.NetworkDetailsRouteType.flows]: {
      id: _types.NetworkDetailsRouteType.flows,
      name: i18n.NAVIGATION_FLOWS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.flows, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.users]: {
      id: _types.NetworkDetailsRouteType.users,
      name: i18n.NAVIGATION_USERS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.users, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.http]: {
      id: _types.NetworkDetailsRouteType.http,
      name: i18n.NAVIGATION_HTTP_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.http, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.tls]: {
      id: _types.NetworkDetailsRouteType.tls,
      name: i18n.NAVIGATION_TLS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.tls, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.anomalies]: {
      id: _types.NetworkDetailsRouteType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.anomalies, flowTarget),
      disabled: false
    },
    [_types.NetworkDetailsRouteType.events]: {
      id: _types.NetworkDetailsRouteType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnNetworkDetailsUrl(ipAddress, _types.NetworkDetailsRouteType.events, flowTarget),
      disabled: false
    }
  };
  if (!hasMlUserPermissions) {
    delete networkDetailsNavTabs.anomalies;
  }
  return networkDetailsNavTabs;
};
exports.navTabsNetworkDetails = navTabsNetworkDetails;