"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsMapping = exports.NetworkKpiDns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kpi_dns_queries = require("../../../../../common/components/visualization_actions/lens_attributes/network/kpi_dns_queries");
var _dns = require("../../../containers/kpi_network/dns");
var _common = require("../../../../hosts/components/kpi_hosts/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _constants = require("../../../../../common/store/inputs/constants");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_refetch_by_session = require("../../../../../common/components/page/use_refetch_by_session");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldsMapping = [{
  key: 'dnsQueries',
  fields: [{
    key: 'dnsQueries',
    value: null,
    lensAttributes: _kpi_dns_queries.kpiDnsQueriesLensAttributes
  }],
  description: i18n.DNS_QUERIES
}];
exports.fieldsMapping = fieldsMapping;
const NetworkKpiDnsComponent = ({
  filterQuery,
  from,
  indexNames,
  to,
  updateDateRange,
  setQuery,
  skip
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_dns.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    refetch,
    id,
    inspect,
    ...data
  }] = (0, _dns.useNetworkKpiDns)({
    filterQuery,
    endDate: to,
    indexNames,
    startDate: from,
    skip: querySkip || isChartEmbeddablesEnabled
  });
  const {
    session,
    refetchByRestartingSession
  } = (0, _use_refetch_by_session.useRefetchByRestartingSession)({
    inputId: _constants.InputsModelId.global,
    queryId: id
  });
  return /*#__PURE__*/_react.default.createElement(_common.KpiBaseComponentManage, {
    data: data,
    id: id,
    inspect: inspect,
    loading: loading,
    fieldsMapping: fieldsMapping,
    from: from,
    to: to,
    updateDateRange: updateDateRange,
    refetch: isChartEmbeddablesEnabled ? refetchByRestartingSession : refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    session: isChartEmbeddablesEnabled ? session : undefined
  });
};
const NetworkKpiDns = /*#__PURE__*/_react.default.memo(NetworkKpiDnsComponent);
exports.NetworkKpiDns = NetworkKpiDns;