"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metric = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _hover_visibility_container = require("../../../common/components/hover_visibility_container");
var _actions = require("../../../common/components/visualization_actions/actions");
var _utils = require("./utils");
var _empty_value = require("../../../common/components/empty_value");
var _utils2 = require("../../../common/components/visualization_actions/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricComponent = ({
  fields,
  id,
  timerange,
  isAreaChartDataAvailable,
  isBarChartDataAvailable,
  inspectTitle,
  inspectIndex
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, fields.map(field => /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    key: `stat-items-field-${field.key}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false
  }, (isAreaChartDataAvailable || isBarChartDataAvailable) && field.icon && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: field.icon,
    color: field.color,
    size: "l",
    "data-test-subj": "stat-icon"
  })), /*#__PURE__*/_react.default.createElement(_utils.FlexItem, null, /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    targetClassNames: [_utils2.VISUALIZATION_ACTIONS_BUTTON_CLASS]
  }, /*#__PURE__*/_react.default.createElement(_utils.StatValue, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "stat-title"
  }, field.value != null ? field.value.toLocaleString() : (0, _empty_value.getEmptyTagValue)(), ' ', field.description)), field.lensAttributes && timerange && /*#__PURE__*/_react.default.createElement(_actions.VisualizationActions, {
    lensAttributes: field.lensAttributes,
    queryId: id,
    inspectIndex: inspectIndex,
    timerange: timerange,
    title: inspectTitle,
    className: "viz-actions"
  })))))));
};
const Metric = /*#__PURE__*/_react.default.memo(MetricComponent);
exports.Metric = Metric;