"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopRiskScoreContributorsAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _eui = require("@elastic/eui");
var _header_section = require("../../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_engine = require("../../../../../common/risk_engine");
var _constants = require("../../../../../common/constants");
var _alerts_table = require("../../../../detections/components/alerts_table");
var _alerts_grouping = require("../../../../detections/components/alerts_table/alerts_grouping");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_selector = require("../../../../common/hooks/use_selector");
var _inputs = require("../../../../common/store/inputs");
var _user_info = require("../../../../detections/components/user_info");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _model = require("../../../../common/store/sourcerer/model");
var _risk_information = require("../risk_information");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopRiskScoreContributorsAlerts = ({
  toggleStatus,
  toggleQuery,
  riskScore,
  riskEntity,
  loading
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const [{
    loading: userInfoLoading,
    signalIndexName,
    hasIndexWrite,
    hasIndexMaintenance
  }] = (0, _user_info.useUserData)();
  const {
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const inputFilters = (0, _react.useMemo)(() => {
    var _riskScoreEntity$risk, _riskScoreEntity$risk2;
    const riskScoreEntity = riskEntity === _risk_engine.RiskScoreEntity.host ? riskScore.host : riskScore.user;
    const riskInputs = (_riskScoreEntity$risk = riskScoreEntity === null || riskScoreEntity === void 0 ? void 0 : (_riskScoreEntity$risk2 = riskScoreEntity.risk) === null || _riskScoreEntity$risk2 === void 0 ? void 0 : _riskScoreEntity$risk2.inputs) !== null && _riskScoreEntity$risk !== void 0 ? _riskScoreEntity$risk : [];
    return [{
      meta: {
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        terms: {
          _id: riskInputs.map(item => item.id)
        }
      }
    }];
  }, [riskScore, riskEntity]);
  const renderGroupedAlertTable = (0, _react.useCallback)(groupingFilters => {
    return /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTableComponent, {
      configId: _constants.ALERTS_TABLE_REGISTRY_CONFIG_IDS.RISK_INPUTS,
      inputFilters: [...inputFilters, ...filters, ...groupingFilters],
      tableId: _securitysolutionDataTable.TableId.alertsRiskInputs
    });
  }, [inputFilters, filters]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "topRiskScoreContributorsAlerts"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.TOP_RISK_SCORE_CONTRIBUTORS,
    hideSubtitle: true,
    toggleQuery: toggleQuery,
    toggleStatus: toggleStatus,
    headerFilters: /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
      riskEntity: riskEntity
    })
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "topRiskScoreContributorsAlerts-table",
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    defaultFilters: [...inputFilters, ...filters],
    from: from,
    globalFilters: filters,
    globalQuery: query,
    hasIndexMaintenance: hasIndexMaintenance !== null && hasIndexMaintenance !== void 0 ? hasIndexMaintenance : false,
    hasIndexWrite: hasIndexWrite !== null && hasIndexWrite !== void 0 ? hasIndexWrite : false,
    loading: userInfoLoading || loading,
    renderChildComponent: renderGroupedAlertTable,
    runtimeMappings: runtimeMappings,
    signalIndexName: signalIndexName,
    tableId: _securitysolutionDataTable.TableId.alertsRiskInputs,
    to: to
  }))));
};
exports.TopRiskScoreContributorsAlerts = TopRiskScoreContributorsAlerts;