"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityFilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("../../../../entity_analytics/common/utils");
var _common = require("./common");
var _translations = require("../translations");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeverityFilterGroup = ({
  severityCount,
  selectedSeverities,
  onSelect,
  riskEntity
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const items = (0, _react.useMemo)(() => {
    const checked = 'on';
    return _utils.SEVERITY_UI_SORT_ORDER.map(severity => ({
      risk: severity,
      count: severityCount[severity],
      checked: selectedSeverities.includes(severity) ? checked : undefined
    }));
  }, [severityCount, selectedSeverities]);
  const updateSeverityFilter = (0, _react.useCallback)(selectedSeverity => {
    const currentSelection = selectedSeverities !== null && selectedSeverities !== void 0 ? selectedSeverities : [];
    const isAddingSeverity = !currentSelection.includes(selectedSeverity);
    const newSelection = isAddingSeverity ? [...currentSelection, selectedSeverity] : currentSelection.filter(s => s !== selectedSeverity);
    if (isAddingSeverity) {
      telemetry.reportEntityRiskFiltered({
        entity: riskEntity,
        selectedSeverity
      });
    }
    onSelect(newSelection);
  }, [selectedSeverities, onSelect, telemetry, riskEntity]);
  const totalActiveItem = (0, _react.useMemo)(() => items.reduce((total, item) => item.checked === 'on' ? total + item.count : total, 0), [items]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "risk-filter-button",
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    numActiveFilters: totalActiveItem,
    onClick: onButtonClick
  }, (0, _translations.ENTITY_RISK_LEVEL)(riskEntity)), [isPopoverOpen, items, onButtonClick, totalActiveItem, riskEntity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, items.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    "data-test-subj": `risk-filter-item-${item.risk}`,
    checked: item.checked,
    key: index + item.risk,
    onClick: () => updateSeverityFilter(item.risk)
  }, /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
    severity: item.risk
  }))))));
};
exports.SeverityFilterGroup = SeverityFilterGroup;