"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListWithSearchComponent = void 0;
var _react = require("react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var i18n = _interopRequireWildcard(require("../../translations"));
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useListWithSearchComponent = (list, refreshExceptions) => {
  const [showAddExceptionFlyout, setShowAddExceptionFlyout] = (0, _react.useState)(false);
  const [showEditExceptionFlyout, setShowEditExceptionFlyout] = (0, _react.useState)(false);
  const [exceptionToEdit, setExceptionToEdit] = (0, _react.useState)();
  const [viewerStatus, setViewerStatus] = (0, _react.useState)(_securitysolutionExceptionListComponents.ViewerStatus.LOADING);
  const onFinishFetchingExceptions = (0, _react.useCallback)(() => {
    setViewerStatus('');
  }, [setViewerStatus]);
  const onEditExceptionItem = exception => {
    setExceptionToEdit(exception);
    setShowEditExceptionFlyout(true);
  };
  const {
    exceptionViewerStatus,
    exceptions,
    lastUpdated,
    pagination,
    ruleReferences: exceptionListReferences,
    fetchItems,
    onDeleteException,
    onPaginationChange
  } = (0, _.useListExceptionItems)({
    list,
    deleteToastTitle: i18n.EXCEPTION_ITEM_DELETE_TITLE,
    deleteToastBody: name => i18n.EXCEPTION_ITEM_DELETE_TEXT(name),
    errorToastBody: i18n.EXCEPTION_ERROR_DESCRIPTION,
    errorToastTitle: i18n.EXCEPTION_ERROR_TITLE,
    onEditListExceptionItem: onEditExceptionItem,
    onFinishFetchingExceptions
  });
  (0, _react.useEffect)(() => {
    fetchItems(null, _securitysolutionExceptionListComponents.ViewerStatus.LOADING);
  }, [fetchItems, refreshExceptions]);
  const emptyViewerTitle = (0, _react.useMemo)(() => {
    return viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.EMPTY ? i18n.EXCEPTION_LIST_EMPTY_VIEWER_TITLE : '';
  }, [viewerStatus]);
  const emptyViewerBody = (0, _react.useMemo)(() => {
    return viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.EMPTY ? i18n.EXCEPTION_LIST_EMPTY_VIEWER_BODY(list.name) : '';
  }, [list.name, viewerStatus]);
  const emptyViewerButtonText = (0, _react.useMemo)(() => {
    return list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON_ENDPOINT : i18n.EXCEPTION_LIST_EMPTY_VIEWER_BUTTON;
  }, [list.type]);

  // #region Callbacks

  const onSearch = (0, _react.useCallback)(async options => {
    setViewerStatus(_securitysolutionExceptionListComponents.ViewerStatus.SEARCHING);
    fetchItems(options, _securitysolutionExceptionListComponents.ViewerStatus.EMPTY_SEARCH);
  }, [fetchItems, setViewerStatus]);
  const onAddExceptionClick = (0, _react.useCallback)(() => {
    setShowAddExceptionFlyout(true);
    fetchItems();
  }, [fetchItems, setShowAddExceptionFlyout]);
  const handleCancelExceptionItemFlyout = () => {
    setShowAddExceptionFlyout(false);
    setShowEditExceptionFlyout(false);
  };
  const handleConfirmExceptionFlyout = (0, _react.useCallback)(didExceptionChange => {
    setShowAddExceptionFlyout(false);
    setShowEditExceptionFlyout(false);
    if (!didExceptionChange) return;
    fetchItems();
  }, [fetchItems, setShowAddExceptionFlyout, setShowEditExceptionFlyout]);
  // #endregion

  return {
    exceptionViewerStatus,
    listName: list.name,
    exceptions,
    listType: list.type,
    lastUpdated,
    pagination,
    viewerStatus,
    emptyViewerTitle,
    emptyViewerBody,
    emptyViewerButtonText,
    ruleReferences: exceptionListReferences,
    showAddExceptionFlyout,
    showEditExceptionFlyout,
    exceptionToEdit,
    onSearch,
    onAddExceptionClick,
    onDeleteException,
    onEditExceptionItem,
    onPaginationChange,
    handleCancelExceptionItemFlyout,
    handleConfirmExceptionFlyout
  };
};
exports.useListWithSearchComponent = useListWithSearchComponent;