"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeExpiredExceptionsModal = exports.CHECK_EXCEPTION_TTL_ACTION_TYPES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHECK_EXCEPTION_TTL_ACTION_TYPES = {
  DUPLICATE: 'duplicate',
  EXPORT: 'export'
};
exports.CHECK_EXCEPTION_TTL_ACTION_TYPES = CHECK_EXCEPTION_TTL_ACTION_TYPES;
const IncludeExpiredExceptionsModal = /*#__PURE__*/(0, _react.memo)(({
  handleCloseModal,
  onModalConfirm,
  action
}) => {
  const [includeExpired, setIncludeExpired] = (0, _react.useState)(true);
  const handleSwitchChange = (0, _react.useCallback)(() => {
    setIncludeExpired(!includeExpired);
  }, [setIncludeExpired, includeExpired]);
  const handleConfirm = (0, _react.useCallback)(() => {
    onModalConfirm(includeExpired);
    handleCloseModal();
  }, [includeExpired, handleCloseModal, onModalConfirm]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: action === CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT ? i18n.EXPIRED_EXCEPTIONS_MODAL_EXPORT_TITLE : i18n.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_TITLE,
    onCancel: handleCloseModal,
    onConfirm: handleConfirm,
    cancelButtonText: i18n.EXPIRED_EXCEPTIONS_MODAL_CANCEL_BUTTON,
    confirmButtonText: action === CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT ? i18n.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_EXPORT_BUTTON : i18n.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_DUPLICATE_BUTTON,
    defaultFocusedButton: "confirm",
    "data-test-subj": "includeExpiredExceptionsConfirmationModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, action === CHECK_EXCEPTION_TTL_ACTION_TYPES.EXPORT ? i18n.EXPIRED_EXCEPTIONS_MODAL_EXPORT_DESCRIPTION : i18n.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: i18n.EXPIRED_EXCEPTIONS_MODAL_INCLUDE_SWITCH_LABEL,
    checked: includeExpired,
    onChange: handleSwitchChange,
    "data-test-subj": "includeExpiredExceptionsConfirmationModalSwitch"
  }));
});
exports.IncludeExpiredExceptionsModal = IncludeExpiredExceptionsModal;
IncludeExpiredExceptionsModal.displayName = 'IncludeExpiredExceptionsModal';