"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaxSpaceTitle = exports.USEFUL_LINKS = exports.UPDATING_RISK_ENGINE = exports.UPDATE_RISK_ENGINE_MODAL_TITLE = exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_2 = exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_1 = exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_2 = exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_1 = exports.UPDATE_RISK_ENGINE_MODAL_BUTTON_YES = exports.UPDATE_RISK_ENGINE_MODAL_BUTTON_NO = exports.UPDATE_PANEL_TITLE = exports.UPDATE_PANEL_MESSAGE = exports.UPDATE_PANEL_GO_TO_MANAGE = exports.UPDATE_PANEL_GO_TO_DISMISS = exports.UPDATE_AVAILABLE = exports.START_UPDATE = exports.SHOW_USERS_RISK_SCORE = exports.SHOW_HOSTS_RISK_SCORE = exports.RISK_SCORE_MODULE_STATUS_ON = exports.RISK_SCORE_MODULE_STATUS_OFF = exports.RISK_SCORE_MODULE_STATUS = exports.PREVIEW_QUERY_ERROR_TITLE = exports.PREVIEW_ERROR_TRY_AGAIN = exports.PREVIEW_ERROR_TITLE = exports.PREVIEW_ERROR_MESSAGE = exports.PREVIEW_DESCRIPTION = exports.PREVIEW = exports.NEED_TO_HAVE = exports.MAX_SPACE_PANEL_MESSAGE = exports.HIDE_USERS_RISK_SCORE = exports.HIDE_HOSTS_RISK_SCORE = exports.ERROR_PANEL_TITLE = exports.ERROR_PANEL_MESSAGE = exports.ERROR_PANEL_ERRORS = exports.ENTITY_RISK_SCORING = exports.EA_DOCS_RISK_USERS = exports.EA_DOCS_RISK_HOSTS = exports.EA_DOCS_ENTITY_RISK_SCORE = exports.EA_DASHBOARD_LINK = exports.CHECK_PRIVILEGES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_HOSTS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.hosts.show', {
  defaultMessage: 'Show hosts'
});
exports.SHOW_HOSTS_RISK_SCORE = SHOW_HOSTS_RISK_SCORE;
const HIDE_HOSTS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.hosts.hide', {
  defaultMessage: 'Hide hosts'
});
exports.HIDE_HOSTS_RISK_SCORE = HIDE_HOSTS_RISK_SCORE;
const SHOW_USERS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.users.show', {
  defaultMessage: 'Show users'
});
exports.SHOW_USERS_RISK_SCORE = SHOW_USERS_RISK_SCORE;
const HIDE_USERS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.users.hide', {
  defaultMessage: 'Hide users'
});
exports.HIDE_USERS_RISK_SCORE = HIDE_USERS_RISK_SCORE;
const RISK_SCORE_MODULE_STATUS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.status', {
  defaultMessage: 'Status'
});
exports.RISK_SCORE_MODULE_STATUS = RISK_SCORE_MODULE_STATUS;
const RISK_SCORE_MODULE_STATUS_ON = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.statusOn', {
  defaultMessage: 'On'
});
exports.RISK_SCORE_MODULE_STATUS_ON = RISK_SCORE_MODULE_STATUS_ON;
const RISK_SCORE_MODULE_STATUS_OFF = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.statusOff', {
  defaultMessage: 'Off'
});
exports.RISK_SCORE_MODULE_STATUS_OFF = RISK_SCORE_MODULE_STATUS_OFF;
const ENTITY_RISK_SCORING = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.entityRiskScoring', {
  defaultMessage: 'Entity risk score'
});
exports.ENTITY_RISK_SCORING = ENTITY_RISK_SCORING;
const USEFUL_LINKS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.usefulLinks', {
  defaultMessage: 'Useful links'
});
exports.USEFUL_LINKS = USEFUL_LINKS;
const EA_DASHBOARD_LINK = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.eaDocsDashboard', {
  defaultMessage: 'Entity Analytics dashboard'
});
exports.EA_DASHBOARD_LINK = EA_DASHBOARD_LINK;
const EA_DOCS_RISK_HOSTS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.eaDocsHosts', {
  defaultMessage: 'Host risk score'
});
exports.EA_DOCS_RISK_HOSTS = EA_DOCS_RISK_HOSTS;
const EA_DOCS_RISK_USERS = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.eaDocsUsers', {
  defaultMessage: 'User risk score'
});
exports.EA_DOCS_RISK_USERS = EA_DOCS_RISK_USERS;
const EA_DOCS_ENTITY_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.eaDocsEntities', {
  defaultMessage: 'How is the risk score calculated?'
});
exports.EA_DOCS_ENTITY_RISK_SCORE = EA_DOCS_ENTITY_RISK_SCORE;
const PREVIEW = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.preview', {
  defaultMessage: 'Preview'
});
exports.PREVIEW = PREVIEW;
const PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.previewDescription', {
  defaultMessage: 'The entities shown in the preview are the riskiest found in the 1000 sampled during your chosen timeframe. They may not be the riskiest entities across all of your data.'
});
exports.PREVIEW_DESCRIPTION = PREVIEW_DESCRIPTION;
const PREVIEW_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.errorTitle', {
  defaultMessage: 'Preview failed'
});
exports.PREVIEW_ERROR_TITLE = PREVIEW_ERROR_TITLE;
const PREVIEW_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.errorMessage', {
  defaultMessage: 'Something went wrong when creating the preview. Please try again.'
});
exports.PREVIEW_ERROR_MESSAGE = PREVIEW_ERROR_MESSAGE;
const PREVIEW_ERROR_TRY_AGAIN = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.tryAgain', {
  defaultMessage: 'Try again'
});
exports.PREVIEW_ERROR_TRY_AGAIN = PREVIEW_ERROR_TRY_AGAIN;
const PREVIEW_QUERY_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.riskScorePreview.queryErrorTitle', {
  defaultMessage: 'Invalid query'
});
exports.PREVIEW_QUERY_ERROR_TITLE = PREVIEW_QUERY_ERROR_TITLE;
const UPDATE_AVAILABLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateAvailable', {
  defaultMessage: 'Update available'
});
exports.UPDATE_AVAILABLE = UPDATE_AVAILABLE;
const START_UPDATE = _i18n.i18n.translate('xpack.securitySolution.riskScore.startUpdate', {
  defaultMessage: 'Start update'
});
exports.START_UPDATE = START_UPDATE;
const UPDATING_RISK_ENGINE = _i18n.i18n.translate('xpack.securitySolution.riskScore.updatingRiskEngine', {
  defaultMessage: 'Updating risk engine...'
});
exports.UPDATING_RISK_ENGINE = UPDATING_RISK_ENGINE;
const UPDATE_RISK_ENGINE_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModa.title', {
  defaultMessage: 'Do you want to update the entity risk engine?'
});
exports.UPDATE_RISK_ENGINE_MODAL_TITLE = UPDATE_RISK_ENGINE_MODAL_TITLE;
const UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_1 = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModal.existingUserHost_1', {
  defaultMessage: 'Existing user and host risk score transforms will be deleted'
});
exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_1 = UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_1;
const UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_2 = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModal.existingUserHost_2', {
  defaultMessage: ', as they are no longer required.'
});
exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_2 = UPDATE_RISK_ENGINE_MODAL_EXISTING_USER_HOST_2;
const UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_1 = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModal.existingData_1', {
  defaultMessage: 'Legacy risk score data will not be deleted'
});
exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_1 = UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_1;
const UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_2 = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModal.existingData_2', {
  defaultMessage: ', it will still exist in the index but will no longer be available in the user interface. You will need to remove legacy risk score data manually.'
});
exports.UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_2 = UPDATE_RISK_ENGINE_MODAL_EXISTING_DATA_2;
const UPDATE_RISK_ENGINE_MODAL_BUTTON_NO = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModal.buttonNo', {
  defaultMessage: 'No, not yet'
});
exports.UPDATE_RISK_ENGINE_MODAL_BUTTON_NO = UPDATE_RISK_ENGINE_MODAL_BUTTON_NO;
const UPDATE_RISK_ENGINE_MODAL_BUTTON_YES = _i18n.i18n.translate('xpack.securitySolution.riskScore.updateRiskEngineModal.buttonYes', {
  defaultMessage: 'Yes, update now!'
});
exports.UPDATE_RISK_ENGINE_MODAL_BUTTON_YES = UPDATE_RISK_ENGINE_MODAL_BUTTON_YES;
const ERROR_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.errorPanel.title', {
  defaultMessage: 'There was an error'
});
exports.ERROR_PANEL_TITLE = ERROR_PANEL_TITLE;
const ERROR_PANEL_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.errorPanel.message', {
  defaultMessage: 'The risk engine status could not be changed. Fix the following and try again:'
});
exports.ERROR_PANEL_MESSAGE = ERROR_PANEL_MESSAGE;
const ERROR_PANEL_ERRORS = _i18n.i18n.translate('xpack.securitySolution.riskScore.errorPanel.errors', {
  defaultMessage: 'Errors'
});
exports.ERROR_PANEL_ERRORS = ERROR_PANEL_ERRORS;
const UPDATE_PANEL_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.updatePanel.title', {
  defaultMessage: 'New entity risk scoring engine available'
});
exports.UPDATE_PANEL_TITLE = UPDATE_PANEL_TITLE;
const UPDATE_PANEL_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.updatePanel.message', {
  defaultMessage: 'A new entity risk scoring engine is available. Update now to get the latest features.'
});
exports.UPDATE_PANEL_MESSAGE = UPDATE_PANEL_MESSAGE;
const UPDATE_PANEL_GO_TO_MANAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.updatePanel.goToManage', {
  defaultMessage: 'Manage'
});
exports.UPDATE_PANEL_GO_TO_MANAGE = UPDATE_PANEL_GO_TO_MANAGE;
const UPDATE_PANEL_GO_TO_DISMISS = _i18n.i18n.translate('xpack.securitySolution.riskScore.updatePanel.Dismiss', {
  defaultMessage: 'Dismiss'
});
exports.UPDATE_PANEL_GO_TO_DISMISS = UPDATE_PANEL_GO_TO_DISMISS;
const getMaxSpaceTitle = maxSpaces => _i18n.i18n.translate('xpack.securitySolution.riskScore.maxSpacePanel.title', {
  defaultMessage: 'You cannot enable entity risk scoring in more than {maxSpaces, plural, =1 {# Kibana space} other {# Kibana spaces}}.',
  values: {
    maxSpaces
  }
});
exports.getMaxSpaceTitle = getMaxSpaceTitle;
const MAX_SPACE_PANEL_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.riskScore.maxSpacePanel.message', {
  defaultMessage: 'You can disable entity risk scoring in the space it is currently enabled before enabling it in this space'
});
exports.MAX_SPACE_PANEL_MESSAGE = MAX_SPACE_PANEL_MESSAGE;
const CHECK_PRIVILEGES = _i18n.i18n.translate('xpack.securitySolution.riskScore.errors.privileges.check', {
  defaultMessage: 'Check privileges'
});
exports.CHECK_PRIVILEGES = CHECK_PRIVILEGES;
const NEED_TO_HAVE = _i18n.i18n.translate('xpack.securitySolution.riskScore.errors.privileges.needToHave', {
  defaultMessage: 'You need to have:'
});
exports.NEED_TO_HAVE = NEED_TO_HAVE;