"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleStep = exports.GroupByOptions = exports.DataSourceType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleStep;
exports.RuleStep = RuleStep;
(function (RuleStep) {
  RuleStep["defineRule"] = "define-rule";
  RuleStep["aboutRule"] = "about-rule";
  RuleStep["scheduleRule"] = "schedule-rule";
  RuleStep["ruleActions"] = "rule-actions";
})(RuleStep || (exports.RuleStep = RuleStep = {}));
let DataSourceType;
exports.DataSourceType = DataSourceType;
(function (DataSourceType) {
  DataSourceType["IndexPatterns"] = "indexPatterns";
  DataSourceType["DataView"] = "dataView";
})(DataSourceType || (exports.DataSourceType = DataSourceType = {}));
let GroupByOptions;
/**
 * add / update data source types to show XOR relationship between 'index' and 'dataViewId' fields
 * Maybe something with io-ts?
 */
exports.GroupByOptions = GroupByOptions;
(function (GroupByOptions) {
  GroupByOptions["PerRuleExecution"] = "per-rule-execution";
  GroupByOptions["PerTimePeriod"] = "per-time-period";
})(GroupByOptions || (exports.GroupByOptions = GroupByOptions = {}));