"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsPrivileges = void 0;
var _react = require("react");
var _user_privileges = require("../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get user privilege from
 *
 */
const useAlertsPrivileges = () => {
  const [privileges, setPrivileges] = (0, _react.useState)({
    isAuthenticated: null,
    hasEncryptionKey: null,
    hasIndexManage: null,
    hasIndexRead: null,
    hasIndexWrite: null,
    hasIndexUpdateDelete: null,
    hasIndexMaintenance: null,
    hasKibanaCRUD: false,
    hasKibanaREAD: false
  });
  const {
    detectionEnginePrivileges,
    kibanaSecuritySolutionsPrivileges: {
      crud: hasKibanaCRUD,
      read: hasKibanaREAD
    }
  } = (0, _user_privileges.useUserPrivileges)();
  (0, _react.useEffect)(() => {
    if (detectionEnginePrivileges.error != null) {
      setPrivileges({
        isAuthenticated: false,
        hasEncryptionKey: false,
        hasIndexManage: false,
        hasIndexRead: false,
        hasIndexWrite: false,
        hasIndexUpdateDelete: false,
        hasIndexMaintenance: false,
        hasKibanaCRUD,
        hasKibanaREAD
      });
    }
  }, [detectionEnginePrivileges.error, hasKibanaCRUD, hasKibanaREAD]);
  (0, _react.useEffect)(() => {
    if (detectionEnginePrivileges.result != null) {
      const privilege = detectionEnginePrivileges.result;
      if (privilege.index != null && Object.keys(privilege.index).length > 0) {
        const indexName = Object.keys(privilege.index)[0];
        setPrivileges({
          isAuthenticated: privilege.is_authenticated,
          hasEncryptionKey: privilege.has_encryption_key,
          hasIndexManage: privilege.index[indexName].manage && privilege.cluster.manage,
          hasIndexMaintenance: privilege.index[indexName].maintenance,
          hasIndexRead: privilege.index[indexName].read,
          hasIndexWrite: privilege.index[indexName].create || privilege.index[indexName].create_doc || privilege.index[indexName].index || privilege.index[indexName].write,
          hasIndexUpdateDelete: privilege.index[indexName].write,
          hasKibanaCRUD,
          hasKibanaREAD
        });
      }
    }
  }, [detectionEnginePrivileges.result, hasKibanaCRUD, hasKibanaREAD]);
  return {
    loading: detectionEnginePrivileges.loading,
    ...privileges
  };
};
exports.useAlertsPrivileges = useAlertsPrivileges;