"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_PROFILES_FAILURE = exports.SIGNAL_POST_FAILURE = exports.SIGNAL_GET_NAME_FAILURE = exports.HOST_ISOLATION_FAILURE = exports.CASES_FROM_ALERTS_FAILURE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIGNAL_GET_NAME_FAILURE = _i18n.i18n.translate('xpack.securitySolution.containers.detectionEngine.alerts.errorGetAlertDescription', {
  defaultMessage: 'Failed to get signal index name'
});
exports.SIGNAL_GET_NAME_FAILURE = SIGNAL_GET_NAME_FAILURE;
const SIGNAL_POST_FAILURE = _i18n.i18n.translate('xpack.securitySolution.containers.detectionEngine.alerts.errorPostAlertDescription', {
  defaultMessage: 'Failed to create signal index'
});
exports.SIGNAL_POST_FAILURE = SIGNAL_POST_FAILURE;
const HOST_ISOLATION_FAILURE = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.failedToIsolate.title', {
  defaultMessage: 'Failed to isolate host'
});
exports.HOST_ISOLATION_FAILURE = HOST_ISOLATION_FAILURE;
const CASES_FROM_ALERTS_FAILURE = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.casesFromAlerts.title', {
  defaultMessage: 'Failed to find associated cases'
});
exports.CASES_FROM_ALERTS_FAILURE = CASES_FROM_ALERTS_FAILURE;
const USER_PROFILES_FAILURE = _i18n.i18n.translate('xpack.securitySolution.containers.detectionEngine.users.userProfiles.title', {
  defaultMessage: 'Failed to find users'
});
exports.USER_PROFILES_FAILURE = USER_PROFILES_FAILURE;