"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepAboutRuleReadOnly = exports.StepAboutRule = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utils = require("../../../../../common/detection_engine/utils");
var _add_item_form = require("../add_item_form");
var _description_step = require("../description_step");
var _mitre = require("../mitre");
var _shared_imports = require("../../../../shared_imports");
var _data = require("./data");
var _validators = require("../../../../common/utils/validators");
var _schema = require("./schema");
var I18n = _interopRequireWildcard(require("./translations"));
var _step_content_wrapper = require("../step_content_wrapper");
var _eui_form = require("../../../../common/components/markdown_editor/eui_form");
var _severity_mapping = require("../severity_mapping");
var _risk_score_mapping = require("../risk_score_mapping");
var _autocomplete_field = require("../autocomplete_field");
var _source = require("../../../../common/containers/source");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _use_rule_indices = require("../../../../detection_engine/rule_management/logic/use_rule_indices");
var _esql_autocomplete = require("../../../../detection_engine/rule_creation/components/esql_autocomplete");
var _multi_select_fields = require("../multi_select_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const ThreeQuartersContainer = _styledComponents.default.div`
  max-width: 740px;
`;
ThreeQuartersContainer.displayName = 'ThreeQuartersContainer';
const TagContainer = _styledComponents.default.div`
  margin-top: 16px;
`;
TagContainer.displayName = 'TagContainer';
const StepAboutRuleComponent = ({
  ruleType,
  machineLearningJobId,
  index,
  dataViewId,
  timestampOverride,
  isActive = false,
  isUpdateView = false,
  isLoading,
  form,
  esqlQuery
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const isThreatMatchRuleValue = (0, _react.useMemo)(() => (0, _utils.isThreatMatchRule)(ruleType), [ruleType]);
  const isEsqlRuleValue = (0, _react.useMemo)(() => (0, _utils.isEsqlRule)(ruleType), [ruleType]);
  const {
    ruleIndices
  } = (0, _use_rule_indices.useRuleIndices)(machineLearningJobId, index);

  /**
   * 1. if not null, fetch data view from id saved on rule form
   * 2. Create a state to set the indexPattern to be used
   * 3. useEffect if indexIndexPattern is updated and dataView from rule form is empty
   */

  const [indexPatternLoading, {
    indexPatterns: indexIndexPattern
  }] = (0, _source.useFetchIndex)(ruleIndices);
  const [indexPattern, setIndexPattern] = (0, _react.useState)(indexIndexPattern);
  (0, _react.useEffect)(() => {
    if (index != null && (dataViewId === '' || dataViewId == null)) {
      setIndexPattern(indexIndexPattern);
    }
  }, [dataViewId, index, indexIndexPattern]);
  (0, _react.useEffect)(() => {
    const fetchSingleDataView = async () => {
      if (dataViewId != null && dataViewId !== '') {
        const dv = await data.dataViews.get(dataViewId);
        setIndexPattern(dv);
      }
    };
    fetchSingleDataView();
  }, [data.dataViews, dataViewId, indexIndexPattern, setIndexPattern]);
  const {
    getFields
  } = form;
  const setRiskScore = (0, _react.useCallback)(severity => {
    const newRiskScoreValue = _data.defaultRiskScoreBySeverity[severity];
    if (newRiskScoreValue != null) {
      const riskScoreField = getFields().riskScore;
      riskScoreField.setValue({
        ...riskScoreField.value,
        value: newRiskScoreValue
      });
    }
  }, [getFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    addPadding: !isUpdateView
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "name",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleName',
      'data-test-subj': 'detectionEngineStepAboutRuleName',
      euiFieldProps: {
        fullWidth: true,
        disabled: isLoading
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "description",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleDescription',
      'data-test-subj': 'detectionEngineStepAboutRuleDescription',
      euiFieldProps: {
        disabled: isLoading,
        compressed: true,
        fullWidth: true
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "severity",
    component: _severity_mapping.SeverityField,
    componentProps: {
      dataTestSubj: 'detectionEngineStepAboutRuleSeverityField',
      idAria: 'detectionEngineStepAboutRuleSeverityField',
      isDisabled: isLoading || indexPatternLoading,
      options: _data.severityOptions,
      indices: indexPattern,
      setRiskScore
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "riskScore",
    component: _risk_score_mapping.RiskScoreField,
    componentProps: {
      dataTestSubj: 'detectionEngineStepAboutRuleRiskScore',
      idAria: 'detectionEngineStepAboutRuleRiskScore',
      isDisabled: isLoading || indexPatternLoading,
      isActive,
      indices: indexPattern
    }
  })), /*#__PURE__*/_react.default.createElement(TagContainer, null, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "tags",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleTags',
      'data-test-subj': 'detectionEngineStepAboutRuleTags',
      euiFieldProps: {
        fullWidth: true,
        isDisabled: isLoading || indexPatternLoading,
        placeholder: ''
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": "advancedSettings",
    id: "advancedSettingsAccordion",
    buttonContent: I18n.ADVANCED_SETTINGS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "references",
    component: _add_item_form.AddItem,
    componentProps: {
      addText: I18n.ADD_REFERENCE,
      idAria: 'detectionEngineStepAboutRuleReferenceUrls',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepAboutRuleReferenceUrls',
      validate: _validators.isUrlInvalid
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "falsePositives",
    component: _add_item_form.AddItem,
    componentProps: {
      addText: I18n.ADD_FALSE_POSITIVE,
      idAria: 'detectionEngineStepAboutRuleFalsePositives',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepAboutRuleFalsePositives'
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "threat",
    component: _mitre.AddMitreAttackThreat,
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleMitreThreat',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepAboutRuleMitreThreat'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "investigationFields",
    component: _multi_select_fields.MultiSelectFieldsAutocomplete,
    componentProps: {
      browserFields: indexPattern.fields,
      isDisabled: isLoading || indexPatternLoading,
      fullWidth: true,
      dataTestSubj: 'detectionEngineStepAboutRuleInvestigationFields'
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "note",
    component: _eui_form.MarkdownEditorForm,
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleNote',
      isDisabled: isLoading,
      dataTestSubj: 'detectionEngineStepAboutRuleNote',
      placeholder: I18n.ADD_RULE_NOTE_HELP_TEXT
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "author",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleAuthor',
      'data-test-subj': 'detectionEngineStepAboutRuleAuthor',
      euiFieldProps: {
        fullWidth: true,
        isDisabled: isLoading,
        placeholder: ''
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "license",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleLicense',
      'data-test-subj': 'detectionEngineStepAboutRuleLicense',
      euiFieldProps: {
        fullWidth: true,
        disabled: isLoading,
        placeholder: ''
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: I18n.GLOBAL_ENDPOINT_EXCEPTION_LIST,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "isAssociatedToEndpointList",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleAssociatedToEndpointList',
      'data-test-subj': 'detectionEngineStepAboutRuleAssociatedToEndpointList',
      euiFieldProps: {
        disabled: isLoading
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: I18n.BUILDING_BLOCK,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "isBuildingBlock",
    componentProps: {
      idAria: 'detectionEngineStepAboutRuleBuildingBlock',
      'data-test-subj': 'detectionEngineStepAboutRuleBuildingBlock',
      euiFieldProps: {
        disabled: isLoading
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isThreatMatchRuleValue && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "threatIndicatorPath",
    componentProps: {
      idAria: 'detectionEngineStepAboutThreatIndicatorPath',
      'data-test-subj': 'detectionEngineStepAboutThreatIndicatorPath',
      euiFieldProps: {
        fullWidth: true,
        disabled: isLoading,
        placeholder: _constants.DEFAULT_INDICATOR_SOURCE_PATH
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isEsqlRuleValue ? /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleNameOverride",
    component: _esql_autocomplete.EsqlAutocomplete,
    componentProps: {
      dataTestSubj: 'detectionEngineStepAboutRuleRuleNameOverrideForEsqlRuleType',
      idAria: 'detectionEngineStepAboutRuleRuleNameOverrideForEsqlRuleType',
      esqlQuery,
      fieldType: 'string',
      isDisabled: isLoading
    }
  }) : /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleNameOverride",
    component: _autocomplete_field.AutocompleteField,
    componentProps: {
      dataTestSubj: 'detectionEngineStepAboutRuleRuleNameOverride',
      fieldType: 'string',
      idAria: 'detectionEngineStepAboutRuleRuleNameOverride',
      indices: indexPattern,
      isDisabled: isLoading || indexPatternLoading,
      placeholder: ''
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "timestampOverride",
    component: _autocomplete_field.AutocompleteField,
    componentProps: {
      dataTestSubj: 'detectionEngineStepAboutRuleTimestampOverride',
      fieldType: 'date',
      idAria: 'detectionEngineStepAboutRuleTimestampOverride',
      indices: indexPattern,
      isDisabled: isLoading || indexPatternLoading,
      placeholder: ''
    }
  }), !!timestampOverride && timestampOverride !== '@timestamp' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "timestampOverrideFallbackDisabled",
    componentProps: {
      idAria: 'detectionTimestampOverrideFallbackDisabled',
      'data-test-subj': 'detectionTimestampOverrideFallbackDisabled',
      euiFieldProps: {
        disabled: isLoading
      }
    }
  }))))));
};
const StepAboutRule = /*#__PURE__*/(0, _react.memo)(StepAboutRuleComponent);
exports.StepAboutRule = StepAboutRule;
const StepAboutRuleReadOnlyComponent = ({
  addPadding,
  defaultValues: data,
  descriptionColumns
}) => {
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    "data-test-subj": "aboutStep",
    addPadding: addPadding
  }, /*#__PURE__*/_react.default.createElement(_description_step.StepRuleDescription, {
    columns: descriptionColumns,
    schema: _schema.schema,
    data: data
  }));
};
const StepAboutRuleReadOnly = /*#__PURE__*/(0, _react.memo)(StepAboutRuleReadOnlyComponent);
exports.StepAboutRuleReadOnly = StepAboutRuleReadOnly;