"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatDefault = exports.stepAboutDefaultValue = void 0;
var _helpers = require("../../../pages/detection_engine/rules/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const threatDefault = [{
  framework: 'MITRE ATT&CK',
  tactic: {
    id: 'none',
    name: 'none',
    reference: 'none'
  },
  technique: []
}];
exports.threatDefault = threatDefault;
const stepAboutDefaultValue = {
  author: [],
  name: '',
  description: '',
  isAssociatedToEndpointList: false,
  isBuildingBlock: false,
  severity: {
    value: 'low',
    mapping: (0, _helpers.fillEmptySeverityMappings)([]),
    isMappingChecked: false
  },
  riskScore: {
    value: 21,
    mapping: [],
    isMappingChecked: false
  },
  references: [''],
  falsePositives: [''],
  investigationFields: [],
  license: '',
  ruleNameOverride: '',
  tags: [],
  timestampOverride: '',
  threat: threatDefault,
  note: ''
};
exports.stepAboutDefaultValue = stepAboutDefaultValue;