"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewRule = void 0;
var _react = require("react");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("../../../../detection_engine/rule_management/api/api");
var _transforms = require("../../../containers/detection_engine/rules/transforms");
var _use_preview_invocation_count = require("./use_preview_invocation_count");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyPreviewRule = {
  previewId: undefined,
  logs: [],
  isAborted: false
};
const usePreviewRule = ({
  timeframeOptions
}) => {
  const [rule, setRule] = (0, _react.useState)(null);
  const [response, setResponse] = (0, _react.useState)(emptyPreviewRule);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    invocationCount,
    interval,
    from
  } = (0, _use_preview_invocation_count.usePreviewInvocationCount)({
    timeframeOptions
  });
  const timeframeEnd = (0, _react.useMemo)(() => timeframeOptions.timeframeEnd.toISOString(), [timeframeOptions]);
  (0, _react.useEffect)(() => {
    if (!rule) {
      setResponse(emptyPreviewRule);
      setIsLoading(false);
    }
  }, [rule]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    setResponse(emptyPreviewRule);
    const createPreviewId = async () => {
      if (rule != null) {
        try {
          setIsLoading(true);
          const previewRuleResponse = await (0, _api.previewRule)({
            rule: {
              ...(0, _transforms.transformOutput)({
                ...rule,
                interval,
                from
              }),
              invocationCount,
              timeframeEnd
            },
            signal: abortCtrl.signal
          });
          if (isSubscribed) {
            setResponse(previewRuleResponse);
          }
        } catch (error) {
          if (isSubscribed) {
            addError(error, {
              title: i18n.RULE_PREVIEW_ERROR
            });
          }
        }
        if (isSubscribed) {
          setIsLoading(false);
        }
      }
    };
    createPreviewId();
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [rule, addError, invocationCount, from, interval, timeframeEnd]);
  return {
    isLoading,
    response,
    rule,
    setRule
  };
};
exports.usePreviewRule = usePreviewRule;