"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MitreAttackTechniqueFields = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var Rulei18n = _interopRequireWildcard(require("../../../pages/detection_engine/rules/translations"));
var _add_item_form = require("../add_item_form");
var i18n = _interopRequireWildcard(require("./translations"));
var _subtechnique_fields = require("./subtechnique_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_mitre_configuration" */
  '../../../mitre/mitre_tactics_techniques')));
};
const hasSubtechniqueOptions = (subtechniquesOptions, technique) => subtechniquesOptions.some(subtechnique => subtechnique.techniqueId === technique.id);
const TechniqueContainer = _styledComponents.default.div`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-left: 24px;
    padding-left: 24px;
    border-left: 2px solid ${theme.eui.euiColorLightestShade};
  `}
`;
const MitreAttackTechniqueFields = ({
  field,
  idAria,
  isDisabled,
  threatIndex,
  onFieldChange
}) => {
  var _values$threatIndex$t;
  const values = field.value;
  const [techniquesOptions, setTechniquesOptions] = (0, _react.useState)([]);
  const [subtechniquesOptions, setSubtechniquesOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setTechniquesOptions(mitreConfig.techniques);
      setSubtechniquesOptions(mitreConfig.subtechniques);
    }
    getMitre();
  }, []);
  const removeTechnique = (0, _react.useCallback)(index => {
    var _threats$threatIndex$;
    const threats = [...field.value];
    const techniques = (_threats$threatIndex$ = threats[threatIndex].technique) !== null && _threats$threatIndex$ !== void 0 ? _threats$threatIndex$ : [];
    techniques.splice(index, 1);
    threats[threatIndex] = {
      ...threats[threatIndex],
      technique: techniques
    };
    onFieldChange(threats);
  }, [field, threatIndex, onFieldChange]);
  const addMitreAttackTechnique = (0, _react.useCallback)(() => {
    var _threats$threatIndex$2;
    const threats = [...field.value];
    threats[threatIndex] = {
      ...threats[threatIndex],
      technique: [...((_threats$threatIndex$2 = threats[threatIndex].technique) !== null && _threats$threatIndex$2 !== void 0 ? _threats$threatIndex$2 : []), {
        id: 'none',
        name: 'none',
        reference: 'none',
        subtechnique: []
      }]
    };
    onFieldChange(threats);
  }, [field, threatIndex, onFieldChange]);
  const updateTechnique = (0, _react.useCallback)((index, optionId) => {
    var _techniquesOptions$fi, _threats$threatIndex$3;
    const threats = [...field.value];
    const {
      id,
      reference,
      name
    } = (_techniquesOptions$fi = techniquesOptions.find(t => t.id === optionId)) !== null && _techniquesOptions$fi !== void 0 ? _techniquesOptions$fi : {
      id: '',
      name: '',
      reference: ''
    };
    const technique = (_threats$threatIndex$3 = threats[threatIndex].technique) !== null && _threats$threatIndex$3 !== void 0 ? _threats$threatIndex$3 : [];
    onFieldChange([...threats.slice(0, threatIndex), {
      ...threats[threatIndex],
      technique: [...technique.slice(0, index), {
        id,
        reference,
        name,
        subtechnique: []
      }, ...technique.slice(index + 1)]
    }, ...threats.slice(threatIndex + 1)]);
  }, [field.value, techniquesOptions, threatIndex, onFieldChange]);
  const getSelectTechnique = (0, _react.useCallback)((tacticName, index, disabled, technique) => {
    const options = techniquesOptions.filter(t => t.tactics.includes((0, _fp.kebabCase)(tacticName)));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      id: "mitreAttackTechnique",
      options: [...(technique.name === 'none' ? [{
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.TECHNIQUE_PLACEHOLDER),
        value: 'none',
        disabled
      }] : []), ...options.map(option => ({
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, option.label),
        value: option.id,
        disabled
      }))],
      prepend: `${field.label} ${i18n.TECHNIQUE}`,
      "aria-label": "",
      onChange: updateTechnique.bind(null, index),
      fullWidth: true,
      valueOfSelected: technique.id,
      "data-test-subj": "mitreAttackTechnique",
      disabled: disabled,
      placeholder: i18n.TECHNIQUE_PLACEHOLDER
    }));
  }, [field.label, techniquesOptions, updateTechnique]);
  const techniques = (_values$threatIndex$t = values[threatIndex].technique) !== null && _values$threatIndex$t !== void 0 ? _values$threatIndex$t : [];
  return /*#__PURE__*/_react.default.createElement(TechniqueContainer, null, techniques.map((technique, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    describedByIds: idAria ? [`${idAria} ${i18n.TECHNIQUE}`] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, getSelectTechnique(values[threatIndex].tactic.name, index, isDisabled, technique)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    isDisabled: isDisabled,
    onClick: () => removeTechnique(index),
    "aria-label": Rulei18n.DELETE
  })))), /*#__PURE__*/_react.default.createElement(_subtechnique_fields.MitreAttackSubtechniqueFields, {
    field: field,
    idAria: idAria,
    isDisabled: isDisabled || technique.name === 'none' || hasSubtechniqueOptions(subtechniquesOptions, technique) === false,
    threatIndex: threatIndex,
    techniqueIndex: index,
    onFieldChange: onFieldChange
  }))), /*#__PURE__*/_react.default.createElement(_add_item_form.MyAddItemButton, {
    "data-test-subj": "addMitreAttackTechnique",
    onClick: addMitreAttackTechnique,
    isDisabled: isDisabled
  }, i18n.ADD_MITRE_TECHNIQUE));
};
exports.MitreAttackTechniqueFields = MitreAttackTechniqueFields;