"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _filter_bar = require("../../../../common/components/filter_bar");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _footer = require("./footer");
var _validators = require("./validators");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextArea = (0, _styledComponents.default)(_eui.EuiTextArea)`
  display: block;
  border: 0;
  box-shadow: none;
  border-radius: 0px;
  min-height: ${({
  theme
}) => theme.eui.euiFormControlHeight};
  &:focus {
    box-shadow: none;
  }
`;
const StyledFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  border: ${({
  theme
}) => theme.eui.euiBorderThin};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};

  .euiFormRow__labelWrapper {
    background: ${({
  theme
}) => theme.eui.euiColorLightestShade};
    border-top-left-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
    border-top-right-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
    padding: 8px 10px;
    margin-bottom: 0px;
    label {
      color: ${({
  theme
}) => theme.eui.euiTextSubduedColor};
      &.euiFormLabel-isInvalid {
        color: ${({
  theme
}) => theme.eui.euiColorDangerText};
      }
    }
  }
`;
const EqlQueryBar = ({
  dataTestSubj,
  field,
  isLoading = false,
  indexPattern,
  showFilterBar,
  idAria,
  optionsData,
  optionsSelected,
  isSizeOptionDisabled,
  onOptionsChange,
  onValidityChange,
  onValiditingChange
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [errorMessages, setErrorMessages] = (0, _react.useState)([]);
  const {
    isValidating,
    value: fieldValue,
    setValue: setFieldValue
  } = field;
  const {
    isValid,
    message,
    messages,
    error
  } = (0, _validators.getValidationResults)(field);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const filterManager = (0, _react.useRef)(new _public.FilterManager(uiSettings));

  // Bubbles up field validity to parent.
  // Using something like form `getErrors` does
  // not guarantee latest validity state
  (0, _react.useEffect)(() => {
    if (onValidityChange != null) {
      onValidityChange(isValid);
    }
  }, [isValid, onValidityChange]);
  (0, _react.useEffect)(() => {
    setErrorMessages(messages !== null && messages !== void 0 ? messages : []);
  }, [messages]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: i18n.EQL_VALIDATION_REQUEST_ERROR
      });
    }
  }, [error, addError]);
  (0, _react.useEffect)(() => {
    if (onValiditingChange) {
      onValiditingChange(isValidating);
    }
  }, [isValidating, onValiditingChange]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const subscriptions = new _rxjs.Subscription();
    filterManager.current.setFilters([]);
    subscriptions.add(filterManager.current.getUpdates$().subscribe({
      next: () => {
        if (isSubscribed) {
          const newFilters = filterManager.current.getFilters();
          const {
            filters
          } = fieldValue;
          if (!(0, _fastDeepEqual.default)(filters, newFilters)) {
            setFieldValue({
              ...fieldValue,
              filters: newFilters
            });
          }
        }
      }
    }));
    return () => {
      isSubscribed = false;
      subscriptions.unsubscribe();
    };
  }, [fieldValue, filterManager, setFieldValue]);
  (0, _react.useEffect)(() => {
    const {
      filters
    } = fieldValue;
    if (!(0, _fastDeepEqual.default)(filters, filterManager.current.getFilters())) {
      filterManager.current.setFilters(filters);
    }
  }, [fieldValue, filterManager]);
  const handleChange = (0, _react.useCallback)(e => {
    const newQuery = e.target.value;
    if (onValiditingChange) {
      onValiditingChange(true);
    }
    setErrorMessages([]);
    setFieldValue({
      filters: fieldValue.filters,
      query: {
        query: newQuery,
        language: 'eql'
      },
      saved_id: null
    });
  }, [fieldValue, setFieldValue, onValiditingChange]);
  return /*#__PURE__*/_react.default.createElement(StyledFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: message,
    isInvalid: !isValid && !isValidating,
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TextArea, {
    "data-test-subj": "eqlQueryBarTextInput",
    fullWidth: true,
    isInvalid: !isValid && !isValidating,
    value: fieldValue.query.query,
    onChange: handleChange
  }), /*#__PURE__*/_react.default.createElement(_footer.EqlQueryBarFooter, {
    errors: errorMessages,
    isLoading: isValidating,
    isSizeOptionDisabled: isSizeOptionDisabled,
    optionsData: optionsData,
    optionsSelected: optionsSelected,
    onOptionsChange: onOptionsChange
  }), showFilterBar && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
    "data-test-subj": "eqlFilterBar",
    indexPattern: indexPattern,
    isLoading: isLoading,
    isRefreshPaused: false,
    filterQuery: fieldValue.query,
    filterManager: filterManager.current,
    filters: filterManager.current.getFilters() || [],
    displayStyle: "inPage"
  }))));
};
exports.EqlQueryBar = EqlQueryBar;