"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSentinelOneAgentData = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/stack-connectors-plugin/public/common");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_sub_action = require("../../../timelines/components/side_panel/event_details/flyout/use_sub_action");
var _use_load_connectors = require("../../../common/components/response_actions/use_load_connectors");
var _sentinel_one_agent_status = require("./sentinel_one_agent_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Using SentinelOne connector to pull agent's data from the SentinelOne API. If the agentId is in the transition state
 * (isolating/releasing) it will keep pulling the state until it finalizes the action
 * @param agentId
 */
const useSentinelOneAgentData = ({
  agentId
}) => {
  var _connector$;
  const sentinelOneManualHostActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const {
    data: connector
  } = (0, _use_load_connectors.useLoadConnectors)({
    actionTypeId: _common.SENTINELONE_CONNECTOR_ID
  });
  return (0, _use_sub_action.useSubAction)({
    connectorId: connector === null || connector === void 0 ? void 0 : (_connector$ = connector[0]) === null || _connector$ === void 0 ? void 0 : _connector$.id,
    subAction: _common.SUB_ACTION.GET_AGENTS,
    subActionParams: {
      uuid: agentId
    },
    disabled: !sentinelOneManualHostActionsEnabled || (0, _lodash.isEmpty)(agentId),
    // @ts-expect-error update types
    refetchInterval: lastResponse => {
      var _lastResponse$data, _lastResponse$data$da;
      const networkStatus = lastResponse === null || lastResponse === void 0 ? void 0 : (_lastResponse$data = lastResponse.data) === null || _lastResponse$data === void 0 ? void 0 : (_lastResponse$data$da = _lastResponse$data.data) === null || _lastResponse$data$da === void 0 ? void 0 : _lastResponse$data$da[0].networkStatus;
      return [_sentinel_one_agent_status.SENTINEL_ONE_NETWORK_STATUS.CONNECTING, _sentinel_one_agent_status.SENTINEL_ONE_NETWORK_STATUS.DISCONNECTING].includes(networkStatus) ? 5000 : false;
    }
  });
};
exports.useSentinelOneAgentData = useSentinelOneAgentData;