"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigateInTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _helpers = require("../../../../common/utils/global_query_string/helpers");
var _defaults = require("../../../../timelines/store/timeline/defaults");
var _kibana = require("../../../../common/lib/kibana");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _timeline3 = require("../../../../timelines/store/timeline");
var _actions = require("../actions");
var _helpers2 = require("../../../../timelines/components/open_timeline/helpers");
var _use_create_timeline = require("../../../../timelines/components/timeline/properties/use_create_timeline");
var _translations = require("../translations");
var _use_selector = require("../../../../common/hooks/use_selector");
var _helpers3 = require("../../../../helpers");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detectionExceptionList = ecsData => {
  var _getField;
  let exceptionsList = (_getField = (0, _helpers3.getField)(ecsData, _ruleDataUtils.ALERT_RULE_EXCEPTIONS_LIST)) !== null && _getField !== void 0 ? _getField : [];
  let detectionExceptionsList = [];
  try {
    if (Array.isArray(exceptionsList) && exceptionsList.length === 0) {
      var _getField2;
      const ruleParameters = (_getField2 = (0, _helpers3.getField)(ecsData, _ruleDataUtils.ALERT_RULE_PARAMETERS)) !== null && _getField2 !== void 0 ? _getField2 : {};
      if (ruleParameters.length > 0) {
        var _parametersObject$exc;
        const parametersObject = JSON.parse(ruleParameters[0]);
        exceptionsList = (_parametersObject$exc = parametersObject === null || parametersObject === void 0 ? void 0 : parametersObject.exceptions_list) !== null && _parametersObject$exc !== void 0 ? _parametersObject$exc : [];
      }
    } else if (exceptionsList && exceptionsList.list_id) {
      return exceptionsList.list_id.map((listId, index) => {
        const type = exceptionsList.type[index];
        return {
          exception_list_id: listId,
          namespace_type: exceptionsList.namespace_type[index],
          type
        };
      }).filter(exception => exception.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION);
    }
  } catch (error) {
    // do nothing, just fail silently as parametersObject is initialized
  }
  detectionExceptionsList = exceptionsList.reduce((acc, next) => {
    // parsed rule.parameters returns an object else use the default string representation
    try {
      const parsedList = typeof next === 'string' ? JSON.parse(next) : next;
      if (parsedList.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION) {
        const formattedList = {
          exception_list_id: parsedList.list_id,
          namespace_type: parsedList.namespace_type
        };
        acc.push(formattedList);
      }
      // eslint-disable-next-line no-empty
    } catch {}
    return acc;
  }, []);
  return detectionExceptionsList;
};
const useInvestigateInTimeline = ({
  ecsRowData,
  onInvestigateInTimelineAlertClick
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data: {
      search: searchStrategyClient,
      query
    }
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    getExceptionFilterFromIds
  } = (0, _securitysolutionListHooks.useApi)(services.http);
  const getExceptionFilter = (0, _react.useCallback)(async ecsData => {
    // This pulls exceptions list information from `_source` for timeline or the fields api for alerts.
    const detectionExceptionsLists = detectionExceptionList(ecsData);
    let exceptionFilter;
    if (detectionExceptionsLists.length > 0) {
      await getExceptionFilterFromIds({
        exceptionListIds: detectionExceptionsLists,
        excludeExceptions: true,
        chunkSize: 20,
        alias: 'Exceptions',
        onSuccess: filter => {
          exceptionFilter = filter;
        },
        onError: err => {
          addError(err, {
            title: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.fetchExceptionFilterFailure', {
              defaultMessage: 'Error fetching exception filter.'
            })
          });
        }
      });
    }
    return exceptionFilter;
  }, [addError, getExceptionFilterFromIds]);
  const filterManagerBackup = (0, _react.useMemo)(() => query.filterManager, [query.filterManager]);
  const getManageTimeline = (0, _react.useMemo)(() => _timeline3.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    filterManager: activeFilterManager
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getManageTimeline, _TimelineId$active;
    return (_getManageTimeline = getManageTimeline(state, (_TimelineId$active = _timeline.TimelineId.active) !== null && _TimelineId$active !== void 0 ? _TimelineId$active : '')) !== null && _getManageTimeline !== void 0 ? _getManageTimeline : _defaults.timelineDefaults;
  });
  const filterManager = (0, _react.useMemo)(() => activeFilterManager !== null && activeFilterManager !== void 0 ? activeFilterManager : filterManagerBackup, [activeFilterManager, filterManagerBackup]);
  const updateTimelineIsLoading = (0, _react.useCallback)(payload => dispatch(_timeline3.timelineActions.updateIsLoading(payload)), [dispatch]);
  const clearActiveTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineType.default
  });
  const createTimeline = (0, _react.useCallback)(({
    from: fromTimeline,
    timeline,
    to: toTimeline,
    ruleNote
  }) => {
    var _timeline$indexNames;
    clearActiveTimeline();
    updateTimelineIsLoading({
      id: _timeline.TimelineId.active,
      isLoading: false
    });
    (0, _helpers2.dispatchUpdateTimeline)(dispatch)({
      duplicate: true,
      from: fromTimeline,
      id: _timeline.TimelineId.active,
      notes: [],
      timeline: {
        ...timeline,
        filterManager,
        indexNames: (_timeline$indexNames = timeline.indexNames) !== null && _timeline$indexNames !== void 0 ? _timeline$indexNames : [],
        show: true
      },
      to: toTimeline,
      ruleNote
    })();
  }, [dispatch, filterManager, updateTimelineIsLoading, clearActiveTimeline]);
  const investigateInTimelineAlertClick = (0, _react.useCallback)(async () => {
    (0, _helpers.createHistoryEntry)();
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.INVESTIGATE_IN_TIMELINE
    });
    if (onInvestigateInTimelineAlertClick) {
      onInvestigateInTimelineAlertClick();
    }
    if (ecsRowData != null) {
      await (0, _actions.sendAlertToTimelineAction)({
        createTimeline,
        ecsData: ecsRowData,
        searchStrategyClient,
        updateTimelineIsLoading,
        getExceptionFilter
      });
    }
  }, [startTransaction, createTimeline, ecsRowData, onInvestigateInTimelineAlertClick, searchStrategyClient, updateTimelineIsLoading, getExceptionFilter]);
  const investigateInTimelineActionItems = (0, _react.useMemo)(() => [{
    key: 'investigate-in-timeline-action-item',
    'data-test-subj': 'investigate-in-timeline-action-item',
    disabled: ecsRowData == null,
    onClick: investigateInTimelineAlertClick,
    name: _translations.ACTION_INVESTIGATE_IN_TIMELINE
  }], [ecsRowData, investigateInTimelineAlertClick]);
  return {
    investigateInTimelineActionItems,
    investigateInTimelineAlertClick
  };
};
exports.useInvestigateInTimeline = useInvestigateInTimeline;