"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _response_actions_list = require("./response_actions_list");
var _response_action_add_button = require("./response_action_add_button");
var _shared_imports = require("../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionsWrapper = /*#__PURE__*/_react.default.memo(({
  items,
  removeItem,
  supportedResponseActionTypes,
  addItem
}) => {
  const actionTypeIdRef = (0, _react.useRef)(null);
  const updateActionTypeId = (0, _react.useCallback)(id => {
    actionTypeIdRef.current = id;
  }, []);
  const context = (0, _shared_imports.useFormContext)();
  const renderButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_response_action_add_button.ResponseActionAddButton, {
      supportedResponseActionTypes: supportedResponseActionTypes,
      addActionType: addItem,
      updateActionTypeId: updateActionTypeId
    });
  }, [addItem, updateActionTypeId, supportedResponseActionTypes]);
  (0, _react.useEffect)(() => {
    if (actionTypeIdRef.current) {
      const index = items.length - 1;
      const path = `responseActions[${index}].actionTypeId`;
      context.setFieldValue(path, actionTypeIdRef.current);
      actionTypeIdRef.current = null;
    }
  }, [context, items.length]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "response-actions-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_response_actions_list.ResponseActionsList, {
    items: items,
    removeItem: removeItem
  }), renderButton);
});
exports.ResponseActionsWrapper = ResponseActionsWrapper;
ResponseActionsWrapper.displayName = 'ResponseActionsWrapper';