"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevelFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rule_monitoring = require("../../../../../../../common/api/detection_engine/rule_monitoring");
var _log_level_indicator = require("../../indicators/log_level_indicator");
var _multiselect_filter = require("../multiselect_filter");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogLevelFilterComponent = ({
  selectedItems,
  onChange
}) => {
  const renderItem = (0, _react.useCallback)(item => {
    return /*#__PURE__*/_react.default.createElement(_log_level_indicator.LogLevelIndicator, {
      logLevel: item
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    dataTestSubj: "logLevelFilter",
    title: i18n.FILTER_TITLE,
    items: _rule_monitoring.LOG_LEVELS,
    selectedItems: selectedItems,
    onSelectionChange: onChange,
    renderItem: renderItem
  });
};
const LogLevelFilter = /*#__PURE__*/_react.default.memo(LogLevelFilterComponent);
exports.LogLevelFilter = LogLevelFilter;
LogLevelFilter.displayName = 'LogLevelFilter';