"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActivityFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleActivityFilterComponent = ({
  selected,
  onChange,
  isLoading
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const numActiveFilters = (0, _react.useMemo)(() => selected.length, [selected]);
  const options = (0, _helpers.populateSelected)(_constants.ruleActivityFilterDefaultOptions, selected);
  const handleSelectableOnChange = (0, _react.useCallback)(newOptions => {
    const formattedOptions = (0, _helpers.extractSelected)(newOptions);
    onChange(formattedOptions);
  }, [onChange]);
  const handleOnClear = (0, _react.useCallback)(() => {
    onChange([]);
  }, [onChange]);
  const renderOptionLabel = option => _constants.ruleActivityFilterLabelMap[option.label];
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "coverageOverviewRuleActivityFilterButton",
    isLoading: isLoading,
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    hasActiveFilters: numActiveFilters > 0,
    numActiveFilters: numActiveFilters
  }, i18n.CoverageOverviewRuleActivityFilterLabel), [isPopoverOpen, numActiveFilters, onButtonClick, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    css: (0, _css.css)`
        width: ${_constants.coverageOverviewFilterWidth}px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "ruleActivityFilterPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, i18n.CoverageOverviewFilterPopoverTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "coverageOverviewFilterList",
    options: options,
    onChange: handleSelectableOnChange,
    renderOption: renderOptionLabel
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _css.css)`
                width: ${_constants.coverageOverviewFilterWidth}px;
              `
  }, list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: (0, _css.css)`
              width: 100%;
            `,
    iconType: "cross",
    color: "danger",
    size: "xs",
    isDisabled: numActiveFilters === 0,
    onClick: handleOnClear
  }, i18n.CoverageOverviewFilterPopoverClearAll))));
};
const RuleActivityFilter = /*#__PURE__*/_react.default.memo(RuleActivityFilterComponent);
exports.RuleActivityFilter = RuleActivityFilter;