"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_SELECTED_RULES = exports.UPDATE_BUTTON_LABEL = exports.UPDATE_ALL = exports.SEARCH_PLACEHOLDER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_ALL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.upgradeAll', {
  defaultMessage: 'Update all'
});
exports.UPDATE_ALL = UPDATE_ALL;
const UPDATE_SELECTED_RULES = numberOfSelectedRules => {
  return _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.upgradeSelected', {
    defaultMessage: 'Update {numberOfSelectedRules} selected rule(s)',
    values: {
      numberOfSelectedRules
    }
  });
};
exports.UPDATE_SELECTED_RULES = UPDATE_SELECTED_RULES;
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.searchBarPlaceholder', {
  defaultMessage: 'Search by rule name'
});
exports.SEARCH_PLACEHOLDER = SEARCH_PLACEHOLDER;
const UPDATE_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.updateButtonLabel', {
  defaultMessage: 'Update'
});
exports.UPDATE_BUTTON_LABEL = UPDATE_BUTTON_LABEL;