"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleScheduleSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../../../detections/pages/detection_engine/rules/helpers");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Interval = ({
  interval
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "intervalPropertyValue"
}, interval);
const From = ({
  from,
  interval
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": `fromPropertyValue-${from}`
}, (0, _helpers.getHumanizedDuration)(from, interval));
const RuleScheduleSection = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  ...descriptionListProps
}) => {
  var _descriptionListProps, _descriptionListProps2;
  if (!rule.interval || !rule.from) {
    return null;
  }
  const ruleSectionListItems = [];
  ruleSectionListItems.push({
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "intervalPropertyTitle"
    }, i18n.INTERVAL_FIELD_LABEL),
    description: /*#__PURE__*/_react.default.createElement(Interval, {
      interval: rule.interval
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "fromPropertyTitle"
    }, i18n.FROM_FIELD_LABEL),
    description: /*#__PURE__*/_react.default.createElement(From, {
      from: rule.from,
      interval: rule.interval
    })
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: ruleSectionListItems,
    columnWidths: columnWidths
  }, descriptionListProps)));
};
exports.RuleScheduleSection = RuleScheduleSection;