"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindExceptionListReferences = void 0;
var _react = require("react");
var _api = require("../../rule_management/api/api");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("../utils/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for finding what rules are referenced by a set of exception lists
 */
const useFindExceptionListReferences = () => {
  const toasts = (0, _kibana.useToasts)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [didError, setError] = (0, _react.useState)(false);
  const [references, setReferences] = (0, _react.useState)(null);
  const findExceptionListAndReferencesRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const findReferences = async listsToFetch => {
      try {
        setIsLoading(true);
        const {
          references: referencesResults
        } = await (0, _api.findRuleExceptionReferences)({
          lists: listsToFetch,
          signal: abortCtrl.signal
        });
        const results = referencesResults.reduce((acc, result) => {
          const [[key, value]] = Object.entries(result);
          acc[key] = value;
          return acc;
        }, {});
        if (isSubscribed) {
          setIsLoading(false);
          setError(false);
          setReferences(results);
        }
      } catch (error) {
        if (isSubscribed) {
          setError(true);
          setIsLoading(false);
          toasts.addError(error, {
            title: i18n.ERROR_FETCHING_REFERENCES_TITLE
          });
        }
      }
    };
    findExceptionListAndReferencesRef.current = findReferences;
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [toasts]);
  return [isLoading, didError, references, findExceptionListAndReferencesRef.current];
};
exports.useFindExceptionListReferences = useFindExceptionListReferences;